/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.TextFieldType;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.jspecify.annotations.Nullable;

public final class TextFieldBuilder {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d*|0");
    private static final UnaryOperator<TextFormatter.Change> INTEGER_FILTER = change -> INTEGER_PATTERN.matcher(change.getControlNewText()).matches() ? change : null;
    private static final Pattern SIGNED_INTEGER_PATTERN = Pattern.compile("-?([1-9]\\d*|0)?");
    private static final UnaryOperator<TextFormatter.Change> SIGNED_INTEGER_FILTER = change -> SIGNED_INTEGER_PATTERN.matcher(change.getControlNewText()).matches() ? change : null;
    private @Nullable String text;
    private TextFieldType type = TextFieldType.TEXT;
    private @Nullable ObservableValue<Boolean> disabled;

    private static TextFormatter<Integer> getIntegerTextFormatter(UnaryOperator<TextFormatter.Change> integerFilter) {
        assert (integerFilter != null) : "arg#1 is null";
        return new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)0, integerFilter);
    }

    TextFieldBuilder() {
    }

    public TextFieldBuilder text(String text) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.text = text;
        return this;
    }

    public TextFieldBuilder type(TextFieldType type) {
        if (type == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.type = type;
        return this;
    }

    public TextFieldBuilder bindDisabled(ObservableBooleanValue disabled) {
        if (disabled == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.disabled = disabled;
        return this;
    }

    public TextField build() {
        TextField tf = new TextField();
        switch (this.type) {
            case INTEGER: {
                tf.setTextFormatter(TextFieldBuilder.getIntegerTextFormatter(INTEGER_FILTER));
                break;
            }
            case SIGNED_INTEGER: {
                tf.setTextFormatter(TextFieldBuilder.getIntegerTextFormatter(SIGNED_INTEGER_FILTER));
                break;
            }
        }
        if (this.text != null) {
            tf.setText(this.text);
        }
        if (this.disabled != null) {
            tf.disableProperty().bind(this.disabled);
        }
        return tf;
    }
}

