/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.ValidationResult;
import com.dua3.utility.fx.controls.Decoration;
import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.fx.icons.IconView;
import com.dua3.utility.lang.LangUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class Validator {
    private static final Logger LOG = LogManager.getLogger(Validator.class);
    private final ResourceBundle resources;
    private final LinkedHashMap<Control, List<Supplier<ValidationResult>>> controls = new LinkedHashMap();
    private final MapProperty<Control, ValidationResult> validationResultProperty = new SimpleMapProperty();
    private final BooleanProperty validProperty = new SimpleBooleanProperty();
    private final List<Runnable> disposeList = new ArrayList<Runnable>();
    private int iconSize = (int)Math.round(Font.getDefault().getSize());
    private String iconError = "fth-alert-triangle";
    private boolean decorateNodes = false;

    public Validator() {
        this(null);
    }

    public void dispose() {
        this.disposeList.forEach(Runnable::run);
        this.disposeList.clear();
    }

    public Validator(@Nullable ResourceBundle resources) {
        this.resources = resources;
    }

    private List<Supplier<ValidationResult>> rules(Control c) {
        assert (c != null) : "arg#1 is null";
        return this.controls.computeIfAbsent(c, this::createRuleList);
    }

    private List<Supplier<ValidationResult>> createRuleList(Control control) {
        assert (control != null) : "arg#1 is null";
        control.setFocusTraversable(true);
        ChangeListener changeListener = (v, o, n) -> this.validateNode(control);
        if (control instanceof InputControl) {
            InputControl c = (InputControl)control;
            c.valueProperty().addListener(changeListener);
            this.disposeList.add(() -> c.valueProperty().removeListener(changeListener));
        } else if (control instanceof TextInputControl) {
            TextInputControl c = (TextInputControl)control;
            c.textProperty().addListener(changeListener);
            this.disposeList.add(() -> c.textProperty().removeListener(changeListener));
        } else {
            control.focusedProperty().addListener((v, o, n) -> this.validateNode(control));
            this.disposeList.add(() -> control.focusedProperty().removeListener(changeListener));
        }
        return new ArrayList<Supplier<ValidationResult>>();
    }

    public void disallowEmpty(TextInputControl c, String message) {
        if (c == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (message == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.rules((Control)c).add(() -> !c.getText().isEmpty() ? ValidationResult.ok((Control)c) : ValidationResult.error((Control)c, (String)message));
    }

    public void setRegex(TextInputControl c, String message, String regex) {
        if (c == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (message == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (regex == null) {
            throw new NullPointerException("arg#3 is null");
        }
        this.rules((Control)c).add(() -> c.getText().matches(regex) ? ValidationResult.ok((Control)c) : ValidationResult.error((Control)c, (String)message));
    }

    public void addCheck(Control c, String message, BooleanSupplier test, Observable ... trigger) {
        if (c == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (message == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (test == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (trigger == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.rules(c).add(() -> test.getAsBoolean() ? ValidationResult.ok((Control)c) : ValidationResult.error((Control)c, (String)message));
        Arrays.stream(trigger).forEach(t -> {
            InvalidationListener il = tt -> this.validateNode(c);
            t.addListener(il);
            this.disposeList.add(() -> t.removeListener(il));
        });
    }

    public void addCheck(Control c, String message, ObservableValue<Boolean> test) {
        if (c == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (message == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (test == null) {
            throw new NullPointerException("arg#3 is null");
        }
        this.rules(c).add(() -> (Boolean)test.getValue() != false ? ValidationResult.ok((Control)c) : ValidationResult.error((Control)c, (String)message));
        test.addListener((v, o, n) -> this.validateNode(c));
    }

    private String getMessage(@Nullable String m) {
        if (m == null || m.isEmpty()) {
            return "";
        }
        if (this.resources == null) {
            return m;
        }
        try {
            return this.resources.getString(m);
        }
        catch (MissingResourceException e) {
            LOG.warn("resource string not found: {}", (Object)m, (Object)e);
            return m;
        }
    }

    public void validateAll() {
        IdentityHashMap<Control, ValidationResult> resultMap = new IdentityHashMap<Control, ValidationResult>(this.controls.keySet().stream().collect(Collectors.toMap(control -> control, this::validate)));
        this.validationResultProperty.set((Object)FXCollections.observableMap(resultMap));
        this.validProperty.set(resultMap.values().stream().anyMatch(entry -> !entry.isOk()));
    }

    private ValidationResult validateNode(Control c) {
        assert (c != null) : "arg#1 is null";
        this.validateAll();
        return Optional.ofNullable((ValidationResult)this.validationResultProperty.get((Object)c)).orElseGet(() -> ValidationResult.ok((Control)c));
    }

    private ValidationResult validate(Control c) {
        assert (c != null) : "arg#1 is null";
        ValidationResult validationResult = this.rules(c).stream().map(Supplier::get).reduce(ValidationResult::merge).orElseGet(() -> ValidationResult.ok((Control)c));
        LOG.debug("validate(): {}", (Object)validationResult);
        this.updateDecoration(c, validationResult);
        return validationResult;
    }

    public void clearDecorations() {
        this.controls.keySet().forEach(c -> Decoration.removeDecoration((Node)c, this.getClass().getName()));
    }

    public void setDecorateNodes(boolean decorateNodes) {
        this.decorateNodes = decorateNodes;
    }

    public boolean isDecorateNodes() {
        return this.decorateNodes;
    }

    private void updateDecoration(Control c, ValidationResult vr) {
        if (!$assertionsDisabled) {
            if (c == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (vr == null) {
                throw new AssertionError((Object)"arg#2 is null");
            }
        }
        if (!this.decorateNodes) {
            return;
        }
        Decoration.getDecorations((Node)c).clear();
        String iconId = null;
        Color paint = null;
        switch (vr.level()) {
            case OK: {
                break;
            }
            case ERROR: {
                iconId = this.iconError;
                paint = Color.RED;
            }
        }
        if (iconId != null) {
            IconView icon = new IconView();
            String message = this.getMessage(vr.message());
            if (!message.isEmpty()) {
                Tooltip.install((Node)icon, (Tooltip)new Tooltip(message));
            }
            icon.setFocusTraversable(false);
            icon.setIconIdentifier(iconId);
            icon.setIconColor((Paint)paint);
            icon.setIconSize(this.iconSize);
            icon.setStyle(String.format("-fx-translate-x: -%1$d; -fx-translate-y: %1$d;", (this.iconSize + 1) / 2));
            Decoration.addDecoration((Node)c, Pos.TOP_RIGHT, (Node)icon, this.getClass().getName());
        } else {
            Decoration.removeDecoration((Node)c, this.getClass().getName());
        }
    }

    public void setIconSize(int sz) {
        this.iconSize = LangUtil.requirePositive((int)sz);
    }

    public void addValidation(@Nullable Button button) {
        if (button == null) {
            LOG.warn("addValidation(): button is null");
            return;
        }
        button.addEventFilter(ActionEvent.ACTION, ae -> {
            if (!this.validProperty.get()) {
                ae.consume();
            }
        });
    }

    public void focusFirst() {
        this.controls.keySet().stream().findFirst().ifPresent(Node::requestFocus);
    }

    public void focusFirstInvalid() {
        this.validationResultProperty.entrySet().stream().filter(entry -> !((ValidationResult)entry.getValue()).isOk()).findFirst().map(Map.Entry::getKey).ifPresent(Node::requestFocus);
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.validProperty;
    }
}

