/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Pair;
import com.dua3.utility.fx.controls.AbstractDialogPaneBuilder;
import com.dua3.utility.fx.controls.InputDialogPane;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class WizardDialog
extends Dialog<Map<String, Object>> {
    private static final Logger LOG = LogManager.getLogger(WizardDialog.class);
    private final ObservableList<Pair<String, Page<?, ?>>> pageStack = FXCollections.observableArrayList();
    private boolean cancelable = true;
    private boolean showPreviousButton = true;
    private @Nullable Map<String, Page<?, ?>> pages;
    private @Nullable Pair<String, Page<?, ?>> current;

    public WizardDialog() {
        this.setResultConverter(btn -> {
            if (btn != ButtonType.FINISH) {
                return null;
            }
            this.pageStack.add(this.current);
            LinkedHashMap result = new LinkedHashMap();
            this.pageStack.forEach(p -> result.put((String)p.first(), ((Page)p.second()).result));
            return result;
        });
    }

    public void setPages(Map<String, Page<?, ?>> pages, String startPage) {
        if (pages == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (startPage == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.pages = pages;
        this.checkPages();
        this.setPage(startPage);
    }

    private void checkPages() {
        Set<String> pageNames = this.pages.keySet();
        for (Map.Entry<String, Page<?, ?>> entry : this.pages.entrySet()) {
            String name = entry.getKey();
            Page<?, ?> page = entry.getValue();
            Object pane = page.getPane();
            String next = page.getNext();
            if (next != null && !pageNames.contains(next)) {
                throw new IllegalStateException(String.format("Page '%s': next page doesn't exist ['%s']", name, next));
            }
            ((InputDialogPane)pane).initButtons();
            if (this.isCancelable()) {
                WizardDialog.addButtonToDialogPane(page, ButtonType.CANCEL, p -> {}, null);
            }
            if (page.getNext() == null) {
                WizardDialog.addButtonToDialogPane(page, ButtonType.FINISH, p -> {}, (BooleanExpression)((InputDialogPane)pane).validProperty());
            } else {
                WizardDialog.addButtonToDialogPane(page, ButtonType.NEXT, p -> {
                    this.pageStack.add((Object)Pair.of((Object)name, (Object)page));
                    this.setPage(page.getNext());
                }, (BooleanExpression)((InputDialogPane)pane).validProperty());
            }
            if (!this.isShowPreviousButton()) continue;
            WizardDialog.addButtonToDialogPane(page, ButtonType.PREVIOUS, p -> this.setPage((String)((Pair)this.pageStack.remove(this.pageStack.size() - 1)).first()), (BooleanExpression)Bindings.isNotEmpty(this.pageStack));
        }
    }

    private void setPage(String pageName) {
        assert (pageName != null) : "arg#1 is null";
        this.current = Pair.of((Object)pageName, this.pages.get(pageName));
        Object pane = ((Page)this.current.second()).pane;
        this.setDialogPane((DialogPane)pane);
        ((InputDialogPane)pane).init();
        pane.layout();
        pane.getScene().getWindow().sizeToScene();
        LOG.debug("current page: {}", (Object)pageName);
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    private static void addButtonToDialogPane(Page<?, ?> page, ButtonType bt, Consumer<? super InputDialogPane<?>> action, @Nullable BooleanExpression enabled) {
        if (!$assertionsDisabled) {
            if (page == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (bt == null) {
                throw new AssertionError((Object)"arg#2 is null");
            }
            if (action == null) {
                throw new AssertionError((Object)"arg#3 is null");
            }
        }
        Object pane = page.pane;
        ObservableList buttons = pane.getButtonTypes();
        buttons.add(bt);
        Button btn = (Button)pane.lookupButton(bt);
        btn.addEventFilter(ActionEvent.ACTION, evt -> {
            if (!page.apply(bt)) {
                LOG.debug("Button {}: result conversion failed", (Object)bt);
                evt.consume();
            }
            action.accept((InputDialogPane<?>)page.getPane());
        });
        if (enabled != null) {
            btn.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)enabled));
        }
    }

    public boolean isShowPreviousButton() {
        return this.showPreviousButton;
    }

    public Page<?, ?> getCurrentPage() {
        return (Page)this.current.second();
    }

    public static class Page<D extends InputDialogPane<R>, R> {
        private D pane;
        private @Nullable String next;
        private @Nullable R result;
        private @Nullable AbstractDialogPaneBuilder.ResultHandler<? super R> resultHandler;
        static final /* synthetic */ boolean $assertionsDisabled;

        @Nullable String getNext() {
            return this.next;
        }

        void setNext(@Nullable String next) {
            this.next = next;
        }

        D getPane() {
            return this.pane;
        }

        void setPane(D pane, AbstractDialogPaneBuilder.ResultHandler<? super R> resultHandler) {
            if (!$assertionsDisabled) {
                if (pane == null) {
                    throw new AssertionError((Object)"arg#1 is null");
                }
                if (resultHandler == null) {
                    throw new AssertionError((Object)"arg#2 is null");
                }
            }
            this.pane = pane;
            this.resultHandler = resultHandler;
        }

        boolean apply(ButtonType btn) {
            if (!$assertionsDisabled && btn == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            Object r = this.pane.get();
            boolean done = this.resultHandler.handleResult(btn, r);
            this.result = done ? r : null;
            return done;
        }

        static {
            $assertionsDisabled = !Page.class.desiredAssertionStatus();
        }
    }
}

