/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.AbstractDialogPaneBuilder;
import com.dua3.utility.fx.controls.AbstractPaneBuilder;
import com.dua3.utility.fx.controls.InputDialogPane;
import com.dua3.utility.fx.controls.WizardDialog;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class WizardDialogBuilder {
    final LinkedHashMap<String, WizardDialog.Page<?, ?>> pages = new LinkedHashMap();
    private String title = "";
    private String startPage = null;

    WizardDialogBuilder() {
    }

    public WizardDialogBuilder title(String title) {
        if (title == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.title = title;
        return this;
    }

    public <D extends InputDialogPane<R>, B extends AbstractPaneBuilder<D, B, R>, R> WizardDialogBuilder page(String name, B builder) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (builder == null) {
            throw new NullPointerException("arg#2 is null");
        }
        WizardDialog.Page page = new WizardDialog.Page();
        page.setNext(builder.next);
        InputDialogPane pane = (InputDialogPane)builder.build();
        AbstractDialogPaneBuilder.ResultHandler resultHandler = builder.getResultHandler();
        page.setPane(pane, resultHandler);
        this.pages.put(name, page);
        if (this.startPage == null) {
            this.setStartPage(name);
        }
        return this;
    }

    public Optional<Map<String, Object>> showAndWait() {
        return this.build().showAndWait();
    }

    public WizardDialog build() {
        WizardDialog dlg = new WizardDialog();
        WizardDialog.Page<?, ?> prev = null;
        for (Map.Entry<String, WizardDialog.Page<?, ?>> entry : this.pages.entrySet()) {
            String name = entry.getKey();
            WizardDialog.Page<?, ?> page = entry.getValue();
            if (prev != null && prev.getNext() == null) {
                prev.setNext(name);
            }
            prev = page;
        }
        dlg.setTitle(this.title);
        dlg.setPages(new LinkedHashMap(this.pages), this.getStartPage());
        return dlg;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        if (startPage == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.startPage = startPage;
    }
}

