/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class AboutDialog
extends Dialog<Void> {
    private static final Logger LOG = LogManager.getLogger(AboutDialog.class);
    Label lTitle;
    Label lVersion;
    Label lCopyright;
    Hyperlink hlMail;
    private String mailAddress = "";

    public AboutDialog() {
        this(null);
    }

    public AboutDialog(@Nullable URL css) {
        URL dialogCss;
        DialogPane dialogPane = new DialogPane();
        VBox vBox = new VBox();
        vBox.setMaxHeight(Double.NEGATIVE_INFINITY);
        vBox.setMaxWidth(Double.POSITIVE_INFINITY);
        this.lTitle = new Label("name");
        this.lTitle.setId("title");
        this.lVersion = new Label("version");
        this.lVersion.setId("version");
        this.lCopyright = new Label("copyright");
        this.lCopyright.setId("copyright");
        this.hlMail = new Hyperlink("email");
        this.hlMail.setId("mail");
        this.hlMail.setOnAction(e -> this.mail());
        vBox.getChildren().setAll((Object[])new Node[]{this.lTitle, this.lVersion, this.lCopyright, this.hlMail});
        StackPane content = new StackPane(new Node[]{vBox});
        content.setId("content");
        content.setMaxHeight(Double.NEGATIVE_INFINITY);
        content.setMaxWidth(Double.POSITIVE_INFINITY);
        dialogPane.setContent((Node)content);
        URL uRL = dialogCss = css != null ? css : AboutDialog.class.getResource("about.css");
        assert (dialogCss != null);
        dialogPane.getStylesheets().add((Object)dialogCss.toExternalForm());
        this.setDialogPane(dialogPane);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
    }

    public void mail() {
        if (!this.isMailAvailable()) {
            LOG.info("Email not configured or Desktop API not supported.");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.MAIL)) {
            try {
                LOG.info("opening mail application");
                desktop.mail(URI.create(this.mailAddress));
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.warn("could not open mail application", (Throwable)e);
            }
        }
    }

    public boolean isMailAvailable() {
        if (this.mailAddress.isBlank()) {
            LOG.info("email not configured");
            return false;
        }
        if (!Desktop.isDesktopSupported()) {
            LOG.info("Desktop API is not supported");
            return false;
        }
        return true;
    }

    public void setName(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.lTitle.setText(value);
    }

    public void setVersion(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.lVersion.setText(value);
    }

    public void setCopyright(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.lCopyright.setText(value);
    }

    public void setEmailText(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.hlMail.setText(value);
    }

    public void setEmailAddress(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.mailAddress = value;
    }
}

