/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.abstract_builders.DialogBuilder;
import java.util.Arrays;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.stage.Window;
import org.jspecify.annotations.Nullable;

public class AlertBuilder
extends DialogBuilder<Alert, AlertBuilder, ButtonType> {
    private @Nullable String css;
    private @Nullable String text;
    private ButtonType @Nullable [] buttons;
    private @Nullable ButtonType defaultButton;

    AlertBuilder(Alert.AlertType type, @Nullable Window parentWindow) {
        assert (type != null) : "type is null";
        super(parentWindow);
        this.css = null;
        this.text = null;
        this.setDialogSupplier(() -> new Alert(type));
    }

    @Override
    public Alert build() {
        Alert dlg = (Alert)super.build();
        if (this.css != null) {
            dlg.getDialogPane().getScene().getStylesheets().add((Object)this.css);
        }
        if (this.buttons != null) {
            dlg.getButtonTypes().setAll((Object[])this.buttons);
        }
        if (this.defaultButton != null) {
            DialogPane pane = dlg.getDialogPane();
            for (ButtonType t : dlg.getButtonTypes()) {
                ((Button)pane.lookupButton(t)).setDefaultButton(t == this.defaultButton);
            }
        }
        if (this.text != null) {
            dlg.setContentText(this.text);
        }
        return dlg;
    }

    public AlertBuilder text(String fmt, Object ... args) {
        if (fmt == null) {
            throw new IllegalArgumentException("fmt is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        this.text = String.format(fmt, args);
        return this;
    }

    public AlertBuilder buttons(ButtonType ... buttons) {
        if (buttons == null) {
            throw new IllegalArgumentException("buttons is null");
        }
        this.buttons = Arrays.copyOf(buttons, buttons.length);
        return this;
    }

    public AlertBuilder defaultButton(ButtonType button) {
        if (button == null) {
            throw new IllegalArgumentException("button is null");
        }
        this.defaultButton = button;
        return this;
    }

    public AlertBuilder css(String css) {
        if (css == null) {
            throw new IllegalArgumentException("css is null");
        }
        this.css = css;
        return this;
    }
}

