/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.InputDialogPane;
import com.dua3.utility.fx.controls.abstract_builders.PaneBuilder;
import javafx.scene.control.Alert;
import javafx.scene.control.DialogPane;
import org.jspecify.annotations.Nullable;

public class AlertPaneBuilder
extends PaneBuilder<InputDialogPane<Void>, AlertPaneBuilder, Void> {
    private @Nullable String text;

    AlertPaneBuilder(Alert.AlertType type) {
        assert (type != null) : "type is null";
        this.setDialogSupplier(() -> AlertPaneBuilder.createPane(type));
    }

    private static InputDialogPane<Void> createPane(Alert.AlertType type) {
        assert (type != null) : "type is null";
        return new InputDialogPane<Void>(){

            @Override
            public void init() {
                this.valid.set(true);
            }

            @Override
            public @Nullable Void get() {
                return null;
            }
        };
    }

    public AlertPaneBuilder text(String fmt, Object ... args) {
        if (fmt == null) {
            throw new IllegalArgumentException("fmt is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        this.text = String.format(fmt, args);
        return this;
    }

    @Override
    public InputDialogPane<Void> build() {
        InputDialogPane inputPane = (InputDialogPane)super.build();
        AlertPaneBuilder.applyIfNotNull(DialogPane::setContentText, inputPane, this.text);
        return inputPane;
    }
}

