/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.abstract_builders.ButtonBaseBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.control.CheckBox;

public class CheckBoxButtonBuilder
extends ButtonBaseBuilder<CheckBox, CheckBoxButtonBuilder> {
    private final List<Property<Boolean>> selectedList;

    CheckBoxButtonBuilder(Supplier<? extends CheckBox> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
        this.selectedList = new ArrayList<Property<Boolean>>();
    }

    public CheckBoxButtonBuilder bindSelected(Property<Boolean> selected) {
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        this.selectedList.add(selected);
        return (CheckBoxButtonBuilder)this.self();
    }

    @Override
    public CheckBox build() {
        CheckBox button = (CheckBox)super.build();
        this.selectedList.forEach(selected -> Bindings.bindBidirectional((Property)selected, (Property)button.selectedProperty()));
        return button;
    }
}

