/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.options.ChoiceOption;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import org.jspecify.annotations.Nullable;

public class ChoiceInputControl<T>
implements InputControl<T> {
    private final ComboBox<// Could not load outer class - annotation placement on inner may be incorrect
    ChoiceOption.Choice<@Nullable T>> control;
    private final ChoiceOption<T> option;
    private final Supplier<? extends @Nullable T> dfltValue;
    private final Property<@Nullable T> valueProperty;

    public ChoiceInputControl(ChoiceOption<T> option, Supplier<? extends @Nullable T> dfltValue) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (dfltValue == null) {
            throw new IllegalArgumentException("dfltValue is null");
        }
        this.option = option;
        this.dfltValue = dfltValue;
        this.control = new ComboBox();
        this.valueProperty = new SimpleObjectProperty();
        this.control.valueProperty().addListener((v, o, n) -> this.valueProperty.setValue(n == null ? null : n.value()));
        this.valueProperty.addListener((v, o, n) -> {
            if (n == null) {
                this.control.getSelectionModel().clearSelection();
            } else {
                this.control.getSelectionModel().select((Object)option.choice(n));
            }
        });
        this.control.getItems().setAll(option.choices());
        Optional.ofNullable(dfltValue.get()).ifPresent(dflt -> this.control.getSelectionModel().select((Object)option.choice(dflt)));
    }

    @Override
    public Node node() {
        return this.control;
    }

    @Override
    public Property<@Nullable T> valueProperty() {
        return this.valueProperty;
    }

    @Override
    public void reset() {
        this.valueProperty.setValue(this.dfltValue.get());
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return new SimpleBooleanProperty(true);
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return new SimpleStringProperty("");
    }
}

