/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.AlertBuilder;
import com.dua3.utility.fx.controls.ButtonBuilder;
import com.dua3.utility.fx.controls.Controls;
import com.dua3.utility.fx.controls.CustomControl;
import com.dua3.utility.fx.controls.Dialogs;
import com.dua3.utility.fx.controls.InputControl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class ComboBoxEx<T>
extends CustomControl<HBox>
implements InputControl<T> {
    private static final Logger LOG = LogManager.getLogger(ComboBoxEx.class);
    private @Nullable Comparator<? super T> comparator;
    private final @Nullable UnaryOperator<T> edit;
    private final @Nullable Supplier<T> add;
    private final @Nullable BiPredicate<ComboBoxEx<T>, T> remove;
    private final Function<T, String> format;
    private final ObservableList<T> items;
    private final ComboBox<T> comboBox;

    @SafeVarargs
    public ComboBoxEx(@Nullable UnaryOperator<T> edit, @Nullable Supplier<T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, Function<T, String> format, T ... items) {
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        this(edit, add, remove, format, (Collection<T>)Arrays.asList(items));
    }

    public ComboBoxEx(@Nullable UnaryOperator<T> edit, @Nullable Supplier<T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, final Function<@Nullable T, String> format, Collection<T> items) {
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        super(new HBox());
        this.comparator = null;
        ((HBox)this.container).setAlignment(Pos.CENTER_LEFT);
        this.getStyleClass().setAll((Object[])new String[]{"comboboxex"});
        this.format = format;
        this.items = FXCollections.observableArrayList(List.copyOf(items));
        this.comboBox = new ComboBox(this.items);
        ObservableList children = ((HBox)this.container).getChildren();
        children.setAll((Object[])new Node[]{this.comboBox});
        if (edit != null) {
            this.edit = edit;
            Button buttonEdit = (Button)((ButtonBuilder)((ButtonBuilder)Controls.button().text("\u270e")).action(this::editItem)).build();
            children.add((Object)buttonEdit);
            buttonEdit.disableProperty().bind((ObservableValue)this.comboBox.selectionModelProperty().isNull());
        } else {
            this.edit = null;
        }
        if (add != null) {
            this.add = add;
            Button buttonAdd = (Button)((ButtonBuilder)((ButtonBuilder)Controls.button().text("+")).action(this::addItem)).build();
            children.add((Object)buttonAdd);
        } else {
            this.add = null;
        }
        if (remove != null) {
            this.remove = remove;
            Button buttonRemove = (Button)((ButtonBuilder)((ButtonBuilder)Controls.button().text("-")).action(this::removeItem)).build();
            children.add((Object)buttonRemove);
            buttonRemove.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.comboBox.getSelectionModel().getSelectedItem() != null && this.items.size() > 1, (Observable[])new Observable[]{this.comboBox.selectionModelProperty(), this.items}));
            buttonRemove.disableProperty().bind((ObservableValue)this.comboBox.selectionModelProperty().isNull().or((ObservableBooleanValue)this.comboBox.valueProperty().isNull()));
        } else {
            this.remove = null;
        }
        Callback cellFactory = new Callback<ListView<T>, ListCell<T>>(this){

            public ListCell<@Nullable T> call(@Nullable ListView<T> lv) {
                return new ListCell<T>(){

                    protected void updateItem(@Nullable T item, boolean empty) {
                        super.updateItem(item, empty);
                        String text = "";
                        if (!empty) {
                            try {
                                text = (String)format.apply(item);
                            }
                            catch (Exception e) {
                                LOG.warn("error during formatting", (Throwable)e);
                                text = String.valueOf(item);
                            }
                        }
                        this.setText(text);
                    }
                };
            }
        };
        this.comboBox.setButtonCell((ListCell)cellFactory.call(null));
        this.comboBox.setCellFactory(cellFactory);
    }

    private void editItem() {
        if (this.edit == null) {
            LOG.warn("editing not supported");
            return;
        }
        int idx = this.comboBox.getSelectionModel().getSelectedIndex();
        if (idx >= 0) {
            Object item = this.items.get(idx);
            if ((item = this.edit.apply(item)) != null) {
                this.items.remove(idx);
                this.items.add(idx, item);
                this.comboBox.getSelectionModel().select(idx);
                this.sortItems();
            }
        }
    }

    private void addItem() {
        Optional.ofNullable(this.add).map(Supplier::get).ifPresent(item -> {
            this.items.add(item);
            this.comboBox.getSelectionModel().select(item);
            this.sortItems();
        });
    }

    private void removeItem() {
        Object item = this.comboBox.getSelectionModel().getSelectedItem();
        if (Optional.ofNullable(this.remove).orElse(ComboBoxEx::alwaysRemoveSelectedItem).test(this, item)) {
            int idx = this.items.indexOf(item);
            this.items.remove(idx);
            idx = Math.min(idx, this.items.size() - 1);
            if (idx >= 0) {
                this.set(this.items.get(idx));
            }
        }
    }

    public boolean askBeforeRemoveSelectedItem(T item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        return ((AlertBuilder)Dialogs.confirmation(Optional.ofNullable(this.getScene()).map(Scene::getWindow).orElse(null)).header("Remove %s?", this.format.apply(item))).defaultButton(ButtonType.YES).build().showAndWait().map(bt -> bt == ButtonType.YES || bt == ButtonType.OK).orElse(false);
    }

    public static <T> boolean alwaysRemoveSelectedItem(ComboBoxEx<T> cb, T item) {
        if (cb == null) {
            throw new IllegalArgumentException("cb is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        return true;
    }

    public Optional<T> getSelectedItem() {
        return Optional.ofNullable(this.comboBox.getSelectionModel().getSelectedItem());
    }

    public List<T> getItems() {
        return List.copyOf(this.items);
    }

    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return ((SingleSelectionModel)this.comboBox.selectionModelProperty().get()).selectedItemProperty();
    }

    public void setComparator(Comparator<? super T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("comparator is null");
        }
        this.comparator = comparator;
        this.sortItems();
    }

    public void sortItems() {
        if (this.comparator == null) {
            return;
        }
        Optional<Object> selectedItem = this.getSelectedItem();
        this.items.sort(this.comparator);
        selectedItem.ifPresent(item -> ((SingleSelectionModel)this.comboBox.selectionModelProperty().get()).select(item));
    }

    @Override
    public Node node() {
        return this;
    }

    @Override
    public Property<@Nullable T> valueProperty() {
        return this.comboBox.valueProperty();
    }

    @Override
    public void reset() {
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return new SimpleBooleanProperty(true);
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return new SimpleStringProperty("");
    }
}

