/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Color;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.controls.ButtonBuilder;
import com.dua3.utility.fx.controls.CheckBoxButtonBuilder;
import com.dua3.utility.fx.controls.DragResizer;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInputBuilder;
import com.dua3.utility.fx.controls.LabelBuilder;
import com.dua3.utility.fx.controls.Position;
import com.dua3.utility.fx.controls.SliderBuilder;
import com.dua3.utility.fx.controls.SliderWithButtons;
import com.dua3.utility.fx.controls.TextBuilder;
import com.dua3.utility.fx.controls.TextFieldBuilder;
import com.dua3.utility.fx.controls.ToggleButtonBuilder;
import com.dua3.utility.fx.icons.Icon;
import com.dua3.utility.fx.icons.IconUtil;
import com.dua3.utility.fx.icons.IconView;
import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public final class Controls {
    private static final Logger LOG = LogManager.getLogger(Controls.class);

    private Controls() {
    }

    public static ButtonBuilder<Button> button() {
        return new ButtonBuilder<Button>(Button::new);
    }

    public static ToggleButtonBuilder toggleButton() {
        return new ToggleButtonBuilder((Supplier<? extends ToggleButton>)((Supplier<ToggleButton>)ToggleButton::new));
    }

    public static ToggleButtonBuilder toggleButton(boolean selected) {
        return new ToggleButtonBuilder((Supplier<? extends ToggleButton>)((Supplier<ToggleButton>)() -> {
            ToggleButton b = new ToggleButton();
            b.setSelected(selected);
            return b;
        }));
    }

    public static CheckBoxButtonBuilder checkbox() {
        return new CheckBoxButtonBuilder((Supplier<? extends CheckBox>)((Supplier<CheckBox>)CheckBox::new));
    }

    public static CheckBoxButtonBuilder checkbox(boolean selected) {
        return new CheckBoxButtonBuilder((Supplier<? extends CheckBox>)((Supplier<CheckBox>)() -> {
            CheckBox b = new CheckBox();
            b.setSelected(selected);
            return b;
        }));
    }

    public static FileInputBuilder fileInput(FileDialogMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        return new FileInputBuilder(mode);
    }

    public static SliderBuilder slider() {
        return new SliderBuilder(SliderWithButtons.Mode.SLIDER_ONLY, (v, t) -> "");
    }

    public static SliderBuilder slider(SliderWithButtons.Mode mode, BiFunction<Double, Double, String> formatter) {
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("formatter is null");
        }
        return new SliderBuilder(mode, formatter);
    }

    public static Node separator(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        return new Separator(orientation);
    }

    public static Node graphic(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return Controls.icon(name).node();
    }

    public static Icon icon(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return (Icon)IconUtil.iconFromName((String)name).orElseThrow(() -> new IllegalStateException("unknown icon: " + name));
    }

    public static Label rigidLabel(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        Label label = new Label(text);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        return label;
    }

    public static Label rigidLabel(String text, Node node) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        Label label = new Label(text, node);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        return label;
    }

    public static Node graphic(String name, int size) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Icon icon = Controls.icon(name);
        icon.setIconSize(size);
        return icon.node();
    }

    public static Node graphic(String name, int size, Paint paint) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (paint == null) {
            throw new IllegalArgumentException("paint is null");
        }
        Icon icon = Controls.icon(name);
        icon.setIconSize(size);
        icon.setIconColor(paint);
        return icon.node();
    }

    public static Node graphic(String name, int size, Color color) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        return Controls.graphic(name, size, (Paint)FxUtil.convert((Color)color));
    }

    public static Node tooltipIcon(String name, int size, Paint paint, String tooltipText) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (paint == null) {
            throw new IllegalArgumentException("paint is null");
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException("tooltipText is null");
        }
        IconView iv = new IconView(name, size, paint);
        if (!tooltipText.isBlank()) {
            iv.setTooltip(new Tooltip(tooltipText));
        }
        return iv;
    }

    public static Node tooltipIcon(String name, int size, Color color, String tooltipText) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException("tooltipText is null");
        }
        return Controls.tooltipIcon(name, size, (Paint)FxUtil.convert((Color)color), tooltipText);
    }

    public static TextFieldBuilder textField(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        return new TextFieldBuilder(locale);
    }

    public static void makeResizable(Region region, Position ... borders) {
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        if (borders == null) {
            throw new IllegalArgumentException("borders is null");
        }
        DragResizer.makeResizable(region, 6, borders);
    }

    public static void makeResizable(Region region, int resizeMargin, Position ... borders) {
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        if (borders == null) {
            throw new IllegalArgumentException("borders is null");
        }
        DragResizer.makeResizable(region, resizeMargin, borders);
    }

    public static Menu menu(String text, MenuItem ... items) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        return Controls.menu(text, null, items);
    }

    public static Menu menu(@Nullable String text, @Nullable Node graphic, MenuItem ... items) {
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        return new Menu(text, graphic, items);
    }

    public static MenuItem menuItem(String text, Runnable action) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        return Controls.menuItem(text, null, action);
    }

    public static MenuItem menuItem(@Nullable String text, @Nullable Node graphic, Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        MenuItem mi = new MenuItem(text, graphic);
        mi.setOnAction(evt -> action.run());
        return mi;
    }

    public static MenuItem menuItem(String text, Runnable action, ObservableBooleanValue enabled) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is null");
        }
        return Controls.menuItem(text, null, action, enabled);
    }

    public static MenuItem menuItem(String text, Runnable action, boolean enabled) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        return Controls.menuItem(text, null, action, FxUtil.constant((boolean)enabled));
    }

    public static MenuItem menuItem(@Nullable String text, @Nullable Node graphic, Runnable action, ObservableBooleanValue enabled) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        MenuItem mi = new MenuItem(text, graphic);
        mi.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)enabled));
        mi.setOnAction(evt -> action.run());
        return mi;
    }

    public static MenuItem menuItem(@Nullable String text, @Nullable Node graphic, Runnable action, boolean enabled) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        return Controls.menuItem(text, graphic, action, FxUtil.constant((boolean)enabled));
    }

    public static CheckMenuItem checkMenuItem(String text, Consumer<Boolean> action, boolean selected) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        return Controls.checkMenuItem(text, null, action, selected);
    }

    public static CheckMenuItem checkMenuItem(@Nullable String text, @Nullable Node graphic, Consumer<Boolean> action, boolean selected) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        CheckMenuItem mi = new CheckMenuItem(text, graphic);
        mi.setOnAction(evt -> action.accept(mi.isSelected()));
        mi.setSelected(selected);
        return mi;
    }

    public static CheckMenuItem checkMenuItem(String text, Property<Boolean> selected) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        return Controls.checkMenuItem(text, null, selected);
    }

    public static CheckMenuItem checkMenuItem(@Nullable String text, @Nullable Node graphic, Property<Boolean> selected) {
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        CheckMenuItem mi = new CheckMenuItem(text, graphic);
        mi.selectedProperty().bindBidirectional(selected);
        return mi;
    }

    public static CheckMenuItem checkMenuItem(String text, Property<Boolean> selected, ObservableBooleanValue enabled) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is null");
        }
        return Controls.checkMenuItem(text, null, selected, enabled);
    }

    public static CheckMenuItem checkMenuItem(String text, Property<Boolean> selected, boolean enabled) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        return Controls.checkMenuItem(text, null, selected, FxUtil.constant((boolean)enabled));
    }

    public static CheckMenuItem checkMenuItem(@Nullable String text, @Nullable Node graphic, Property<Boolean> selected, ObservableBooleanValue enabled) {
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is null");
        }
        if (text == null && graphic == null) {
            throw new IllegalArgumentException("text and graphic must not both be null");
        }
        CheckMenuItem mi = new CheckMenuItem(text, graphic);
        mi.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)enabled));
        mi.selectedProperty().bindBidirectional(selected);
        return mi;
    }

    public static CheckMenuItem checkMenuItem(@Nullable String text, @Nullable Node graphic, Property<Boolean> selected, boolean enabled) {
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        return Controls.checkMenuItem(text, graphic, selected, FxUtil.constant((boolean)enabled));
    }

    public static TextBuilder text(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        return new TextBuilder(text);
    }

    public static TextBuilder text(ObservableValue<String> text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        return new TextBuilder(text);
    }

    public static LabelBuilder label(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        return new LabelBuilder(text);
    }

    public static LabelBuilder label(ObservableValue<String> text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        return new LabelBuilder(text);
    }

    static void setInitialDirectory(Consumer<File> setInitialDirectory, @Nullable Path dir) {
        assert (setInitialDirectory != null) : "setInitialDirectory is null";
        if (dir != null) {
            try {
                File initialFile = dir.toFile();
                if (initialFile.isDirectory()) {
                    setInitialDirectory.accept(initialFile);
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("could not set initial directory", (Throwable)e);
            }
        }
    }

    public static Background background(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        return new Background(new BackgroundFill[]{new BackgroundFill((Paint)FxUtil.convert((Color)color), null, null)});
    }
}

