/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.Decoration;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;

class DecorationPane
extends AnchorPane {
    static final String DECORATION_PANE = "com.dua3.decoration_pane";

    DecorationPane(Parent sceneRoot) {
        assert (sceneRoot != null) : "sceneRoot is null";
        this.setBackground(null);
        this.getChildren().setAll((Object[])new Node[]{sceneRoot});
    }

    static DecorationPane getDecorationPane(Node node) {
        assert (node != null) : "node is null";
        DecorationPane decorationPane = (DecorationPane)((Object)node.getProperties().get((Object)DECORATION_PANE));
        if (decorationPane == null) {
            decorationPane = DecorationPane.getDecorationPane(node.getScene());
            node.getProperties().put((Object)DECORATION_PANE, (Object)decorationPane);
        }
        return decorationPane;
    }

    private static DecorationPane getDecorationPane(Scene scene) {
        assert (scene != null) : "scene is null";
        Parent sceneRoot = scene.getRoot();
        if (sceneRoot instanceof DecorationPane) {
            return (DecorationPane)sceneRoot;
        }
        DecorationPane decorationPane = new DecorationPane(sceneRoot);
        scene.setRoot((Parent)decorationPane);
        scene.addPostLayoutPulseListener(decorationPane::updateDecorationLayout);
        return decorationPane;
    }

    private void updateDecorationLayout() {
        this.getChildren().forEach(Decoration::updateDecorationPosition);
    }

    void removeDecoration(Object oldDecoration) {
        assert (oldDecoration != null) : "oldDecoration is null";
        this.getChildren().remove(oldDecoration);
    }
}

