/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.Controls;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.Nullable;

public class DirectoryChooserBuilder {
    private static final Logger LOG = LogManager.getLogger(DirectoryChooserBuilder.class);
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private Path initialDir = USER_HOME;

    DirectoryChooserBuilder() {
    }

    public Optional<Path> showDialog(@Nullable Window parent) {
        DirectoryChooser chooser = this.build();
        return Optional.ofNullable(chooser.showDialog(parent)).map(File::toPath);
    }

    private DirectoryChooser build() {
        DirectoryChooser chooser = new DirectoryChooser();
        Controls.setInitialDirectory(arg_0 -> ((DirectoryChooser)chooser).setInitialDirectory(arg_0), this.initialDir);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((DirectoryChooser)chooser).getInitialDirectory();
        LOG.debug("initial directory: {}", supplierArray);
        return chooser;
    }

    public DirectoryChooserBuilder initialDir(@Nullable Path initialDir) {
        this.initialDir = initialDir != null ? initialDir : USER_HOME;
        return this;
    }
}

