/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.ComboBoxEx;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInput;
import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.options.Arguments;
import com.dua3.utility.options.Option;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import org.jspecify.annotations.Nullable;

public interface InputBuilder<B extends InputBuilder<B>> {
    public <T> B add(String var1, String var2, Class<T> var3, Supplier<T> var4, InputControl<T> var5);

    public <T> B add(String var1, Class<T> var2, Supplier<T> var3, InputControl<T> var4);

    public B addNode(String var1, String var2, Node var3);

    public B addNode(String var1, Node var2);

    public B columns(int var1);

    default public B string(String id, String label, Supplier<String> dflt) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        return this.string(id, label, dflt, s -> Optional.empty());
    }

    public B string(String var1, String var2, Supplier<String> var3, Function<String, Optional<String>> var4);

    default public B integer(String id, String label, Supplier<Integer> dflt) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        return this.integer(id, label, dflt, i -> Optional.empty());
    }

    public B integer(String var1, String var2, Supplier<Integer> var3, Function<Integer, Optional<String>> var4);

    default public B decimal(String id, String label, Supplier<Double> dflt) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        return this.decimal(id, label, dflt, d -> Optional.empty());
    }

    public B decimal(String var1, String var2, Supplier<Double> var3, Function<Double, Optional<String>> var4);

    default public B checkBox(String id, String label, Supplier<Boolean> dflt, String text) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        return this.checkBox(id, label, dflt, text, b -> Optional.empty());
    }

    public B checkBox(String var1, String var2, Supplier<Boolean> var3, String var4, Function<Boolean, Optional<String>> var5);

    default public <T> B comboBox(String id, String label, Supplier<T> dflt, Class<T> cls, Collection<T> items) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (cls == null) {
            throw new IllegalArgumentException("cls is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        return this.comboBox(id, label, dflt, cls, items, t -> Optional.empty());
    }

    public <T> B comboBox(String var1, String var2, Supplier<T> var3, Class<T> var4, Collection<T> var5, Function<T, Optional<String>> var6);

    default public <T> B comboBoxEx(String id, String label, @Nullable UnaryOperator<@Nullable T> edit, @Nullable Supplier<@Nullable T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, Function<T, String> format, Supplier<@Nullable T> dflt, Class<T> cls, Collection<T> items) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (cls == null) {
            throw new IllegalArgumentException("cls is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        return this.comboBoxEx(id, label, edit, add, remove, format, dflt, cls, items, t -> Optional.empty());
    }

    public <T> B comboBoxEx(String var1, String var2, @Nullable UnaryOperator<T> var3, @Nullable Supplier<T> var4, @Nullable BiPredicate<ComboBoxEx<T>, T> var5, Function<T, String> var6, Supplier<T> var7, Class<T> var8, Collection<T> var9, Function<T, Optional<String>> var10);

    default public <T> B radioList(String id, String label, Supplier<@Nullable T> dflt, Class<T> cls, Collection<T> items) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (cls == null) {
            throw new IllegalArgumentException("cls is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        return this.radioList(id, label, dflt, cls, items, t -> t != null ? Optional.empty() : Optional.of("No option selected"));
    }

    public <T> B radioList(String var1, String var2, Supplier<T> var3, Class<T> var4, Collection<T> var5, Function<T, Optional<String>> var6);

    public B options(String var1, String var2, Supplier<Arguments> var3, Supplier<Collection<Option<?>>> var4);

    public B options(String var1, Supplier<Arguments> var2, Supplier<Collection<Option<?>>> var3);

    default public B chooseFile(String id, String label, Supplier<@Nullable Path> dflt, FileDialogMode mode, boolean existingOnly, Collection<FileChooser.ExtensionFilter> filter) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        return this.chooseFile(id, label, dflt, mode, existingOnly, filter, FileInput.defaultValidate(mode, existingOnly));
    }

    public B chooseFile(String var1, String var2, Supplier<Path> var3, FileDialogMode var4, boolean var5, Collection<FileChooser.ExtensionFilter> var6, Function<Path, Optional<String>> var7);

    public B node(String var1, Node var2);

    public B node(String var1, String var2, Node var3);
}

