/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.ComboBoxEx;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInput;
import com.dua3.utility.fx.controls.FormatWithDefaultValue;
import com.dua3.utility.fx.controls.SimpleInputControl;
import java.nio.file.Path;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import org.jspecify.annotations.Nullable;

public interface InputControl<T> {
    public static SimpleInputControl<TextField, String> stringInput(Supplier<String> dflt, Function<String, Optional<String>> validate) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        TextField control = new TextField();
        StringProperty value = control.textProperty();
        return new SimpleInputControl<TextField, String>(control, (Property<String>)value, dflt, validate);
    }

    public static <T> SimpleInputControl<TextField, T> stringInput(Supplier<T> dflt, Function<@Nullable T, Optional<String>> validate, StringConverter<@Nullable T> converter) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        TextField control = new TextField();
        SimpleObjectProperty value = new SimpleObjectProperty();
        Bindings.bindBidirectional((Property)control.textProperty(), (Property)value, converter);
        return new SimpleInputControl<TextField, T>(control, value, dflt, validate);
    }

    public static SimpleInputControl<TextField, Integer> integerInput(Supplier<@Nullable Integer> dflt, Function<@Nullable Integer, Optional<String>> validate) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        TextField control = new TextField();
        StringProperty textProperty = control.textProperty();
        SimpleIntegerProperty value = new SimpleIntegerProperty();
        FormatWithDefaultValue format = new FormatWithDefaultValue(NumberFormat.getIntegerInstance(Locale.getDefault()), dflt);
        textProperty.bindBidirectional((Property)value, (Format)format);
        return new SimpleInputControl<TextField, Integer>(control, (Property<Integer>)value.asObject(), dflt, validate);
    }

    public static SimpleInputControl<TextField, Double> decimalInput(Supplier<@Nullable Double> dflt, Function<@Nullable Double, Optional<String>> validate) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        TextField control = new TextField();
        StringProperty textProperty = control.textProperty();
        SimpleDoubleProperty value = new SimpleDoubleProperty();
        FormatWithDefaultValue format = new FormatWithDefaultValue(NumberFormat.getInstance(Locale.getDefault()), dflt);
        textProperty.bindBidirectional((Property)value, (Format)format);
        return new SimpleInputControl<TextField, Double>(control, (Property<Double>)value.asObject(), dflt, validate);
    }

    public static SimpleInputControl<CheckBox, Boolean> checkBoxInput(Supplier<@Nullable Boolean> dflt, String text, Function<@Nullable Boolean, Optional<String>> validate) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        CheckBox control = new CheckBox(text);
        BooleanProperty value = control.selectedProperty();
        return new SimpleInputControl<CheckBox, Boolean>(control, (Property<Boolean>)value.asObject(), dflt, validate);
    }

    public static <T> SimpleInputControl<ComboBox<T>, T> comboBoxInput(Collection<? extends T> choices, Supplier<T> dflt, Function<T, Optional<String>> validate) {
        if (choices == null) {
            throw new IllegalArgumentException("choices is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        ComboBox control = new ComboBox(FXCollections.observableArrayList(choices));
        ObjectProperty value = control.valueProperty();
        return new SimpleInputControl<ComboBox, T>(control, value, dflt, validate);
    }

    public static <T> SimpleInputControl<ComboBoxEx<T>, T> comboBoxExInput(Collection<T> choices, Supplier<T> dflt, @Nullable UnaryOperator<T> edit, @Nullable Supplier<T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, Function<T, String> format, Function<T, Optional<String>> validate) {
        if (choices == null) {
            throw new IllegalArgumentException("choices is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        ComboBoxEx<T> control = new ComboBoxEx<T>(edit, add, remove, format, FXCollections.observableArrayList(choices));
        Property<T> value = control.valueProperty();
        return new SimpleInputControl<ComboBoxEx<T>, T>(control, value, dflt, validate);
    }

    public static InputControl<Path> chooseFile(Supplier<Path> dflt, FileDialogMode mode, boolean existingOnly, Collection<FileChooser.ExtensionFilter> filters, Function<Path, Optional<String>> validate) {
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (filters == null) {
            throw new IllegalArgumentException("filters is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        return new FileInput(mode, existingOnly, dflt, filters, validate);
    }

    public Node node();

    default public @Nullable T get() {
        return (T)this.valueProperty().getValue();
    }

    public Property<@Nullable T> valueProperty();

    default public void set(@Nullable T arg) {
        this.valueProperty().setValue(arg);
    }

    default public boolean isValid() {
        return this.validProperty().get();
    }

    default public void init() {
    }

    public void reset();

    public ReadOnlyBooleanProperty validProperty();

    public ReadOnlyStringProperty errorProperty();

    public static class State<R> {
        private final Property<R> value;
        private final BooleanProperty valid;
        private final StringProperty error;
        private Supplier<? extends R> dflt;
        private Function<? super R, Optional<String>> validate;
        static final /* synthetic */ boolean $assertionsDisabled;

        public State(Property<R> value) {
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            this(value, State.freeze(value));
        }

        public State(Property<R> value, Supplier<R> dflt) {
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            if (dflt == null) {
                throw new IllegalArgumentException("dflt is null");
            }
            this(value, dflt, s -> Optional.empty());
        }

        private static <R> Supplier<R> freeze(ObservableValue<? extends R> value) {
            if (!$assertionsDisabled && value == null) {
                throw new AssertionError((Object)"value is null");
            }
            Object frozen = value.getValue();
            return () -> frozen;
        }

        public State(Property<R> value, Supplier<? extends R> dflt, Function<? super R, Optional<String>> validate) {
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            if (dflt == null) {
                throw new IllegalArgumentException("dflt is null");
            }
            if (validate == null) {
                throw new IllegalArgumentException("validate is null");
            }
            this.valid = new SimpleBooleanProperty(true);
            this.error = new SimpleStringProperty("");
            this.value = value;
            this.value.addListener((v, o, n) -> this.updateValidState(n));
            this.dflt = dflt;
            this.validate = validate;
            this.value.addListener((v, o, n) -> this.updateValidState(n));
        }

        private void updateValidState(@Nullable R r) {
            Optional<String> result = this.validate.apply(r);
            this.valid.setValue(Boolean.valueOf(result.isEmpty()));
            this.error.setValue(result.orElse(""));
        }

        public void setValidate(Function<? super R, Optional<String>> validate) {
            if (validate == null) {
                throw new IllegalArgumentException("validate is null");
            }
            this.validate = validate;
            this.updateValidState(this.valueProperty().getValue());
        }

        public Property<R> valueProperty() {
            return this.value;
        }

        public ReadOnlyBooleanProperty validProperty() {
            return this.valid;
        }

        public ReadOnlyStringProperty errorProperty() {
            return this.error;
        }

        public void setDefault(Supplier<? extends R> dflt) {
            if (dflt == null) {
                throw new IllegalArgumentException("dflt is null");
            }
            this.dflt = dflt;
        }

        public void reset() {
            this.value.setValue(this.dflt.get());
        }

        static {
            $assertionsDisabled = !State.class.desiredAssertionStatus();
        }
    }
}

