/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.abstract_builders.DialogPaneBuilder;
import com.dua3.utility.lang.LangUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public abstract class InputDialogPane<R>
extends DialogPane
implements Supplier<R> {
    private static final Logger LOG = LogManager.getLogger(InputDialogPane.class);
    protected final BooleanProperty valid = new SimpleBooleanProperty(false);
    protected final List<ButtonDef<? super R>> buttons = new ArrayList<ButtonDef<? super R>>();

    public abstract void init();

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    public void addButton(ButtonType type,  @Nullable DialogPaneBuilder.ResultHandler<R> resultHandler, Consumer<InputDialogPane<R>> action, @Nullable BooleanExpression enabled) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        ObservableList bt = this.getButtonTypes();
        bt.add((Object)type);
        Button btn = (Button)this.lookupButton(type);
        btn.addEventFilter(ActionEvent.ACTION, evt -> {
            boolean done;
            if (resultHandler != null && !(done = resultHandler.handleResult(type, this.get()))) {
                LOG.debug("Button {}: result conversion failed", (Object)bt);
                evt.consume();
            }
            action.accept(this);
        });
        if (enabled != null) {
            btn.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)enabled));
        }
    }

    protected Node createButton(ButtonType buttonType) {
        assert (buttonType != null) : "buttonType is null";
        if (LangUtil.isOneOf((Object)buttonType, (Object[])new ButtonType[]{ButtonType.OK, ButtonType.FINISH, ButtonType.CANCEL})) {
            return super.createButton(buttonType);
        }
        Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        button.setCancelButton(buttonData.isCancelButton());
        return button;
    }

    public record ButtonDef<R>(ButtonType type, DialogPaneBuilder.ResultHandler<R> resultHandler, Consumer<InputDialogPane<R>> action, BooleanExpression enabled) {
        public ButtonDef {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            if (resultHandler == null) {
                throw new IllegalArgumentException("resultHandler is null");
            }
            if (action == null) {
                throw new IllegalArgumentException("action is null");
            }
            if (enabled == null) {
                throw new IllegalArgumentException("enabled is null");
            }
        }
    }
}

