/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Converter;
import com.dua3.utility.fx.FxFontUtil;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PropertyConverter;
import com.dua3.utility.fx.controls.abstract_builders.LabeledBuilder;
import com.dua3.utility.text.Font;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import org.jspecify.annotations.Nullable;

public class LabelBuilder
extends LabeledBuilder<Label, LabelBuilder> {
    private final ObservableValue<String> text;
    private @Nullable ObservableValue<javafx.scene.text.Font> font;

    protected LabelBuilder(String text) {
        assert (text != null) : "text is null";
        super(Label::new);
        this.font = null;
        this.text = new SimpleStringProperty(text);
    }

    protected LabelBuilder(ObservableValue<String> text) {
        assert (text != null) : "text is null";
        super(Label::new);
        this.font = null;
        this.text = text;
    }

    @Override
    public Label build() {
        Label node = (Label)super.build();
        this.apply(this.text, node.textProperty());
        this.apply(this.font, node.fontProperty());
        return node;
    }

    @Override
    public LabelBuilder font(javafx.scene.text.Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)font);
        return (LabelBuilder)this.self();
    }

    @Override
    public LabelBuilder font(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)FxFontUtil.getInstance().convert(font));
        return (LabelBuilder)this.self();
    }

    public LabelBuilder bindFontFx(ObservableValue<javafx.scene.text.Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = font;
        return (LabelBuilder)this.self();
    }

    @Override
    public LabelBuilder bindFont(ObservableValue<Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = PropertyConverter.convertReadOnly(font, (Converter)FxUtil.fontConverter());
        return (LabelBuilder)this.self();
    }
}

