/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.ChoiceInputControl;
import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.fx.controls.SimpleInputControl;
import com.dua3.utility.options.Arguments;
import com.dua3.utility.options.ChoiceOption;
import com.dua3.utility.options.Flag;
import com.dua3.utility.options.Option;
import com.dua3.utility.options.SimpleOption;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class OptionsPane
extends GridPane
implements InputControl<Arguments> {
    protected static final Logger LOG = LogManager.getLogger(OptionsPane.class);
    private static final Insets INSETS = new Insets(2.0);
    private final InputControl.State<@Nullable Arguments> state;
    private final Supplier<? extends Collection<Option<?>>> options;
    private final Supplier<@Nullable Arguments> dflt;
    private final Map<Option<?>, InputControl<?>> items;

    public OptionsPane(Collection<Option<?>> optionSet, Arguments currentValues) {
        if (optionSet == null) {
            throw new IllegalArgumentException("optionSet is null");
        }
        if (currentValues == null) {
            throw new IllegalArgumentException("currentValues is null");
        }
        this(() -> optionSet, () -> currentValues);
    }

    public OptionsPane(Supplier<? extends Collection<Option<?>>> options, Supplier<Arguments> dflt) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (dflt == null) {
            throw new IllegalArgumentException("dflt is null");
        }
        this.items = new LinkedHashMap();
        this.options = options;
        this.dflt = dflt;
        SimpleObjectProperty value = new SimpleObjectProperty();
        this.state = new InputControl.State<Arguments>((Property<Arguments>)value, dflt);
    }

    @Override
    public Node node() {
        return this;
    }

    @Override
    public Arguments get() {
        ArrayDeque<Arguments.Entry> entries = new ArrayDeque<Arguments.Entry>();
        for (Map.Entry<Option<?>, InputControl<?>> entry : this.items.entrySet()) {
            Option<?> option = entry.getKey();
            Object value = entry.getValue().valueProperty().getValue();
            if (value == null) continue;
            entries.add(Arguments.createEntry(option, (Object[])new Object[]{value}));
        }
        return Arguments.of((Arguments.Entry[])((Arguments.Entry[])entries.toArray(Arguments.Entry[]::new)));
    }

    @Override
    public void set(@Nullable Arguments arg) {
        for (Map.Entry<Option<?>, InputControl<?>> item : this.items.entrySet()) {
            Option<?> option = item.getKey();
            InputControl<?> control = item.getValue();
            Stream stream = Objects.requireNonNullElseGet(arg, Arguments::empty).stream(option);
            Optional<Object> value = stream.filter(list -> !list.isEmpty()).reduce((first, second) -> second).map(list -> list.get(list.size() - 1));
            control.set(value.orElse(null));
        }
    }

    @Override
    public void init() {
        this.getChildren().clear();
        Collection<Option<?>> optionSet = this.options.get();
        Arguments values = this.dflt.get();
        int row = 0;
        for (Option<?> option : optionSet) {
            Label label = new Label(option.displayName());
            InputControl<?> control = this.createControl(Objects.requireNonNullElseGet(values, Arguments::empty), option);
            this.items.put(option, control);
            this.addToGrid((Node)label, 0, row);
            this.addToGrid(control.node(), 1, row);
            ++row;
        }
    }

    private <T> InputControl<T> createControl(Arguments values, final Option<T> option) {
        if (!$assertionsDisabled) {
            if (values == null) {
                throw new AssertionError((Object)"values is null");
            }
            if (option == null) {
                throw new AssertionError((Object)"option is null");
            }
        }
        Option<T> option2 = option;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChoiceOption.class, Flag.class, SimpleOption.class}, option2, n)) {
            case 0: {
                ChoiceOption co = (ChoiceOption)option2;
                return new ChoiceInputControl<T>(co, OptionsPane.supplyDefault(co, values));
            }
            case 1: {
                Flag f = (Flag)option2;
                CheckBox checkBox = new CheckBox(f.displayName());
                return new SimpleInputControl<CheckBox, T>(checkBox, checkBox.selectedProperty(), OptionsPane.supplyDefault(f, values), OptionsPane.nopValidator());
            }
            case 2: {
                SimpleOption so = (SimpleOption)option2;
                StringConverter converter = new StringConverter<T>(this){

                    public String toString(T v) {
                        if (v == null) {
                            throw new IllegalArgumentException("v is null");
                        }
                        return option.format(v);
                    }

                    public T fromString(String s) {
                        if (s == null) {
                            throw new IllegalArgumentException("s is null");
                        }
                        return option.map(s);
                    }
                };
                return InputControl.stringInput(OptionsPane.supplyDefault(so, values), OptionsPane.nopValidator(), converter);
            }
        }
        throw new UnsupportedOperationException("unsupported input type: " + option.getClass().getName());
    }

    private static <T> T getValue(Option<T> option, Arguments values) {
        if (!$assertionsDisabled) {
            if (option == null) {
                throw new AssertionError((Object)"option is null");
            }
            if (values == null) {
                throw new AssertionError((Object)"values is null");
            }
        }
        Option<T> option2 = option;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Flag.class, SimpleOption.class, ChoiceOption.class}, option2, n)) {
            case 0 -> {
                Flag flag = (Flag)option2;
                yield values.isSet(flag);
            }
            case 1 -> {
                SimpleOption so = (SimpleOption)option2;
                yield values.get(so).orElse(so.getDefault());
            }
            case 2 -> {
                ChoiceOption co = (ChoiceOption)option2;
                yield values.get(co).orElse(co.getDefault());
            }
            default -> throw new IllegalArgumentException("Unknown option type: " + String.valueOf(option));
        });
    }

    private static <T> Function<T, Optional<String>> nopValidator() {
        return s -> Optional.empty();
    }

    private static <T> Supplier<T> supplyDefault(Option<? extends T> option, Arguments values) {
        if (!$assertionsDisabled) {
            if (option == null) {
                throw new AssertionError((Object)"option is null");
            }
            if (values == null) {
                throw new AssertionError((Object)"values is null");
            }
        }
        return () -> OptionsPane.getValue(option, values);
    }

    private void addToGrid(@Nullable Node node, int c, int r) {
        if (node != null) {
            this.add(node, c, r);
            OptionsPane.setMargin((Node)node, (Insets)INSETS);
        }
    }

    @Override
    public void reset() {
        this.items.forEach((item, control) -> control.reset());
    }

    @Override
    public Property<@Nullable Arguments> valueProperty() {
        return this.state.valueProperty();
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.state.validProperty();
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return this.state.errorProperty();
    }
}

