/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PlatformHelper;
import com.dua3.utility.fx.controls.PinBoardSkin;
import com.dua3.utility.fx.controls.ScrollPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;

public class PinBoard
extends Control {
    final ObservableList<Item> items = FXCollections.observableArrayList();
    private final ObjectProperty<Rectangle2D> areaProperty = new SimpleObjectProperty((Object)new Rectangle2D(0.0, 0.0, 0.0, 0.0));
    private final BooleanProperty pannableProperty = new SimpleBooleanProperty(true);
    private final DoubleProperty scrollHValueProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty scrollVValueProperty = new SimpleDoubleProperty(0.0);

    public PinBoard() {
        this.skinProperty().addListener((v, o, n) -> {
            if (o instanceof PinBoardSkin) {
                PinBoardSkin oldSkin = (PinBoardSkin)((Object)o);
                oldSkin.pannableProperty().unbind();
                oldSkin.scrollHValueProperty().unbindBidirectional((Property)this.scrollHValueProperty);
                oldSkin.scrollVValueProperty().unbindBidirectional((Property)this.scrollVValueProperty);
            }
            if (n instanceof PinBoardSkin) {
                PinBoardSkin newSkin = (PinBoardSkin)((Object)n);
                newSkin.pannableProperty().bind((ObservableValue)this.pannableProperty);
                newSkin.scrollHValueProperty().bindBidirectional((Property)this.scrollHValueProperty);
                newSkin.scrollVValueProperty().bindBidirectional((Property)this.scrollVValueProperty);
            }
        });
    }

    public void setHbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setHbarPolicy(policy);
        }
    }

    public void setVbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setVbarPolicy(policy);
        }
    }

    public DoubleProperty scrollHValuePropertyProperty() {
        return this.scrollHValueProperty;
    }

    public DoubleProperty scrollVValuePropertyProperty() {
        return this.scrollVValueProperty;
    }

    public List<Item> getVisibleItems() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            return skin2.getVisibleItems();
        }
        return Collections.emptyList();
    }

    public void clear() {
        PlatformHelper.checkApplicationThread();
        this.items.clear();
        this.areaProperty.set((Object)new Rectangle2D(0.0, 0.0, 0.0, 0.0));
    }

    public void refresh() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.refresh();
        }
    }

    public void dispose() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.dispose();
        }
    }

    protected Skin<PinBoard> createDefaultSkin() {
        return new PinBoardSkin(this);
    }

    public ReadOnlyObjectProperty<Rectangle2D> areaProperty() {
        return this.areaProperty;
    }

    public BooleanProperty pannableProperty() {
        return this.pannableProperty;
    }

    public ObservableList<Item> getItems() {
        return FXCollections.unmodifiableObservableList(this.items);
    }

    public ScrollPosition getScrollPosition() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            return skin2.getScrollPosition();
        }
        return ScrollPosition.ORIGIN;
    }

    public void setScrollPosition(double hValue, double vValue) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setScrollPosition(hValue, vValue);
        }
    }

    public void setScrollPosition(ScrollPosition scrollPosition) {
        if (scrollPosition == null) {
            throw new IllegalArgumentException("scrollPosition is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setScrollPosition(scrollPosition);
        }
    }

    public void scrollTo(PositionInItem pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollTo(pos);
        }
    }

    public void scrollTo(PositionInItem pos, double relativeXinVP, double relativeYinVP) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollTo(pos, relativeXinVP, relativeYinVP);
        }
    }

    public void scroll(double deltaX, double deltaY) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scroll(deltaX, deltaY);
        }
    }

    public void scrollHorizontal(double delta) {
        this.scroll(delta, 0.0);
    }

    public void scrollVertical(double delta) {
        this.scroll(0.0, delta);
    }

    public void scrollIntoView(PositionInItem pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollIntoView(pos);
        }
    }

    public void scrollTo(double x, double y) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollTo(x, y);
        }
    }

    public void scrollTo(double x, double y, double relativeXinVP, double relativeYinVP) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollTo(x, y, relativeXinVP, relativeYinVP);
        }
    }

    public void scrollIntoView(double x, double y) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollIntoView(x, y);
        }
    }

    public Optional<Item> getItemAt(double x, double y) {
        return this.getPositionInItem(x, y).map(PositionInItem::item);
    }

    public Optional<PositionInItem> getPositionInItem(double x, double y) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            return skin2.getPositionInItem(x, y);
        }
        return Optional.empty();
    }

    public void pinBottom(String name, Supplier<Node> nodeSupplier, Dimension2D dimension) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (nodeSupplier == null) {
            throw new IllegalArgumentException("nodeSupplier is null");
        }
        if (dimension == null) {
            throw new IllegalArgumentException("dimension is null");
        }
        Rectangle2D boardArea = this.getArea();
        double xCenter = (boardArea.getMaxX() + boardArea.getMinX()) / 2.0;
        double y = boardArea.getMaxY();
        Rectangle2D area = new Rectangle2D(xCenter - dimension.getWidth() / 2.0, y, dimension.getWidth(), dimension.getHeight());
        this.pin(new Item(name, area, nodeSupplier));
    }

    public Rectangle2D getArea() {
        return (Rectangle2D)this.areaProperty.get();
    }

    public void pin(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        this.pin(Collections.singleton(item));
    }

    public void pin(Collection<Item> itemsToPin) {
        if (itemsToPin == null) {
            throw new IllegalArgumentException("itemsToPin is null");
        }
        PlatformHelper.checkApplicationThread();
        if (itemsToPin.isEmpty()) {
            return;
        }
        this.items.addAll(itemsToPin);
        itemsToPin.stream().map(Item::area).reduce(FxUtil::union).map(r -> FxUtil.union((Rectangle2D)this.getArea(), (Rectangle2D)r)).ifPresent(r -> {
            if (!r.equals((Object)this.getArea())) {
                this.areaProperty.set(r);
            }
        });
    }

    public String toString() {
        return "PinBoard{area=" + String.valueOf(this.areaProperty.get()) + ", items=" + String.valueOf(this.items) + "}";
    }

    public record PositionInItem(Item item, double x, double y) {
        public PositionInItem {
            if (item == null) {
                throw new IllegalArgumentException("item is null");
            }
        }
    }

    public record Item(String name, Rectangle2D area, Supplier<Node> nodeBuilder) {
        public Item {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (area == null) {
                throw new IllegalArgumentException("area is null");
            }
            if (nodeBuilder == null) {
                throw new IllegalArgumentException("nodeBuilder is null");
            }
        }
    }

    public record BoardPosition(double x, double y) {
    }
}

