/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxRefresh;
import com.dua3.utility.fx.PlatformHelper;
import com.dua3.utility.fx.controls.PinBoard;
import com.dua3.utility.fx.controls.ScrollPosition;
import com.dua3.utility.lang.LangUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.AnchorPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PinBoardSkin
extends SkinBase<PinBoard> {
    private static final Logger LOG = LogManager.getLogger(PinBoardSkin.class);
    private final FxRefresh refresher;
    private final AnchorPane pane;
    private final ScrollPane scrollPane;

    PinBoardSkin(PinBoard pinBoard) {
        assert (pinBoard != null) : "pinBoard is null";
        super((Control)pinBoard);
        this.pane = new AnchorPane();
        this.scrollPane = new ScrollPane((Node)this.pane);
        this.refresher = FxRefresh.create((String)LangUtil.defaultToString((Object)((Object)this)), () -> PlatformHelper.runLater(this::updateNodes), (Node)pinBoard);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.getChildren().setAll((Object[])new Node[]{this.scrollPane});
        pinBoard.areaProperty().addListener((v, o, n) -> {
            this.pane.setMinWidth(n.getWidth());
            this.pane.setMinHeight(n.getHeight());
        });
        pinBoard.getItems().addListener(c -> this.refresh());
        this.pane.layoutBoundsProperty().addListener(o -> this.refresh());
        this.scrollPane.hvalueProperty().addListener(h -> this.refresh());
        this.scrollPane.vvalueProperty().addListener(v -> this.refresh());
        this.scrollPane.widthProperty().addListener(e -> this.refresh());
        this.scrollPane.heightProperty().addListener(e -> this.refresh());
        this.scrollPane.viewportBoundsProperty().addListener((v, o, n) -> this.refresh());
        this.refresher.setActive(true);
    }

    private void updateNodes() {
        LOG.trace("updateNodes()");
        PlatformHelper.checkApplicationThread();
        PinBoard board = (PinBoard)this.getSkinnable();
        Rectangle2D viewPort = this.getViewPort();
        Rectangle2D boardArea = board.getArea();
        double dx = Math.max(0.0, viewPort.getWidth() - boardArea.getWidth()) / 2.0 - boardArea.getMinX();
        double dy = Math.max(0.0, viewPort.getHeight() - boardArea.getHeight()) / 2.0 - boardArea.getMinY();
        Rectangle2D viewportInLocal = new Rectangle2D(viewPort.getMinX() + boardArea.getMinX(), viewPort.getMinY() + boardArea.getMinY(), viewPort.getWidth(), viewPort.getHeight());
        List<Node> nodes = new ArrayList<PinBoard.Item>((Collection<PinBoard.Item>)board.items).stream().filter(item -> item.area().intersects(viewportInLocal)).map(item -> {
            LOG.debug("item is visible: {}", (Object)item.name());
            Rectangle2D itemArea = item.area();
            Node node = item.nodeBuilder().get();
            node.setTranslateX(dx + itemArea.getMinX());
            node.setTranslateY(dy + itemArea.getMinY());
            return node;
        }).toList();
        this.pane.setMinWidth(boardArea.getWidth());
        this.pane.setMinHeight(boardArea.getHeight());
        this.pane.getChildren().setAll(nodes);
    }

    void refresh() {
        this.refresher.refresh();
    }

    private Rectangle2D getViewPort() {
        Bounds vpBounds = this.scrollPane.getViewportBounds();
        return new Rectangle2D(-vpBounds.getMinX(), -vpBounds.getMinY(), vpBounds.getWidth(), vpBounds.getHeight());
    }

    public void dispose() {
        this.refresher.stop();
        super.dispose();
    }

    public DoubleProperty scrollHValueProperty() {
        return this.scrollPane.hvalueProperty();
    }

    public DoubleProperty scrollVValueProperty() {
        return this.scrollPane.vvalueProperty();
    }

    public ScrollPosition getScrollPosition() {
        return new ScrollPosition(this.scrollPane.getHvalue(), this.scrollPane.getVvalue());
    }

    public void setScrollPosition(ScrollPosition scrollPosition) {
        if (scrollPosition == null) {
            throw new IllegalArgumentException("scrollPosition is null");
        }
        this.setScrollPosition(scrollPosition.hValue(), scrollPosition.vValue());
    }

    public void setScrollPosition(double hValue, double vValue) {
        this.scrollPane.setHvalue(hValue);
        this.scrollPane.setVvalue(vValue);
    }

    public Optional<PinBoard.PositionInItem> getPositionInItem(double xViewport, double yViewport) {
        Rectangle2D vp = this.getViewPortInBoardCoordinates();
        double x = xViewport + vp.getMinX();
        double y = yViewport + vp.getMinY();
        ArrayList<PinBoard.Item> items = new ArrayList<PinBoard.Item>((Collection<PinBoard.Item>)((PinBoard)this.getSkinnable()).getItems());
        for (PinBoard.Item item : items) {
            Rectangle2D a = item.area();
            if (!a.contains(x, y)) continue;
            return Optional.of(new PinBoard.PositionInItem(item, x - a.getMinX(), y - a.getMinY()));
        }
        return Optional.empty();
    }

    public List<PinBoard.Item> getVisibleItems() {
        ArrayList<PinBoard.Item> visibleItems = new ArrayList<PinBoard.Item>();
        Rectangle2D b = this.getViewPortInBoardCoordinates();
        ArrayList<PinBoard.Item> items = new ArrayList<PinBoard.Item>((Collection<PinBoard.Item>)((PinBoard)this.getSkinnable()).getItems());
        for (PinBoard.Item item : items) {
            Rectangle2D a = item.area();
            if (!a.intersects(b)) continue;
            visibleItems.add(item);
        }
        return visibleItems;
    }

    private Rectangle2D getViewPortInBoardCoordinates() {
        Bounds vp = this.scrollPane.getViewportBounds();
        Rectangle2D boardArea = ((PinBoard)this.getSkinnable()).getArea();
        return new Rectangle2D(boardArea.getMinX() - vp.getMinX(), boardArea.getMinY() - vp.getMinY(), vp.getWidth(), vp.getHeight());
    }

    public PinBoard.BoardPosition toBoardPosition(double xLocal, double yLocal) {
        Rectangle2D area = ((PinBoard)this.getSkinnable()).getArea();
        return new PinBoard.BoardPosition(area.getMinX() + xLocal, area.getMinY() + yLocal);
    }

    public PinBoard.BoardPosition toBoardPosition(PinBoard.PositionInItem pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        Rectangle2D area = pos.item().area();
        double xBoard = area.getMinX() + pos.x();
        double yBoard = area.getMinY() + pos.y();
        return new PinBoard.BoardPosition(xBoard, yBoard);
    }

    public void scrollTo(PinBoard.PositionInItem pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        this.scrollTo(this.toBoardPosition(pos));
    }

    public void scrollTo(PinBoard.PositionInItem pos, double relativeXinVP, double relativeYinVP) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        PinBoard.BoardPosition bp = this.toBoardPosition(pos);
        this.scrollTo(bp.x(), bp.y(), relativeXinVP, relativeYinVP);
    }

    public void scroll(double deltaX, double deltaY) {
        ScrollPosition pos = this.getScrollPosition();
        Rectangle2D area = ((PinBoard)this.getSkinnable()).getArea();
        Bounds vpBounds = this.scrollPane.getViewportBounds();
        double spWidth = this.scrollPane.getHmax() - this.scrollPane.getHmin();
        double spHeight = this.scrollPane.getVmax() - this.scrollPane.getVmin();
        double scWidth = area.getWidth() - vpBounds.getWidth();
        double scHeight = area.getHeight() - vpBounds.getHeight();
        double factorH = spWidth / scWidth;
        double factorV = spHeight / scHeight;
        this.setScrollPosition(pos.hValue() - deltaX * factorH, pos.vValue() - deltaY * factorV);
    }

    public void scrollIntoView(PinBoard.PositionInItem pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        this.scrollIntoView(this.toBoardPosition(pos));
    }

    public void scrollTo(PinBoard.BoardPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        this.scrollTo(pos.x(), pos.y());
    }

    public void scrollIntoView(PinBoard.BoardPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos is null");
        }
        this.scrollIntoView(pos.x(), pos.y());
    }

    public void scrollTo(double x, double y) {
        this.scrollTo(x, y, 0.0, 0.0);
    }

    public void scrollTo(double x, double y, double relativeXinVP, double relativeYinVP) {
        LOG.debug("scrollTo({}, {}, {}, {})", (Object)x, (Object)y, (Object)relativeXinVP, (Object)relativeYinVP);
        Rectangle2D boardArea = ((PinBoard)this.getSkinnable()).getArea();
        if (boardArea.getWidth() == 0.0 || boardArea.getHeight() == 0.0) {
            return;
        }
        Bounds viewportBounds = this.scrollPane.getViewportBounds();
        double tx = Math.clamp(relativeXinVP, 0.0, 1.0) * viewportBounds.getWidth();
        double ty = Math.clamp(relativeYinVP, 0.0, 1.0) * viewportBounds.getHeight();
        double sx = PinBoardSkin.calcScrollPosition(x - tx, boardArea.getMinX(), boardArea.getMaxX(), viewportBounds.getWidth());
        double sy = PinBoardSkin.calcScrollPosition(y - ty, boardArea.getMinY(), boardArea.getMaxY(), viewportBounds.getHeight());
        this.setScrollPosition(sx, sy);
    }

    public void scrollIntoView(double xBoard, double yBoard) {
        LOG.debug("scrollIntoViewInBoardCoordinates({}, {})", (Object)xBoard, (Object)yBoard);
        Rectangle2D boardArea = ((PinBoard)this.getSkinnable()).getArea();
        if (boardArea.getWidth() == 0.0 || boardArea.getHeight() == 0.0) {
            return;
        }
        Bounds viewportBounds = this.scrollPane.getViewportBounds();
        Rectangle2D viewPortInBoardCoordinates = this.getViewPortInBoardCoordinates();
        if (xBoard < viewPortInBoardCoordinates.getMinX()) {
            this.scrollPane.setHvalue(PinBoardSkin.calcScrollPosition(xBoard, boardArea.getMinX(), boardArea.getMaxX(), viewportBounds.getWidth()));
        } else if (xBoard > viewPortInBoardCoordinates.getMaxX()) {
            this.scrollPane.setHvalue(PinBoardSkin.calcScrollPosition(xBoard - viewportBounds.getWidth(), boardArea.getMinX(), boardArea.getMaxX(), viewportBounds.getWidth()));
        }
        if (yBoard < viewPortInBoardCoordinates.getMinY()) {
            this.scrollPane.setVvalue(PinBoardSkin.calcScrollPosition(yBoard, boardArea.getMinY(), boardArea.getMaxY(), viewportBounds.getHeight()));
        } else if (yBoard > viewPortInBoardCoordinates.getMaxY()) {
            this.scrollPane.setVvalue(PinBoardSkin.calcScrollPosition(yBoard - viewportBounds.getHeight(), boardArea.getMinY(), boardArea.getMaxY(), viewportBounds.getHeight()));
        }
    }

    private static double calcScrollPosition(double c, double tMin, double tMax, double viewableSize) {
        double totalSize = tMax - tMin;
        double scrollableSize = totalSize - viewableSize;
        if (scrollableSize <= 0.0) {
            return 0.0;
        }
        if (c >= scrollableSize) {
            return 1.0;
        }
        return (c - tMin) / scrollableSize;
    }

    public void setHbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy is null");
        }
        this.scrollPane.setHbarPolicy(policy);
    }

    public void setVbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy is null");
        }
        this.scrollPane.setVbarPolicy(policy);
    }

    public BooleanProperty pannableProperty() {
        return this.scrollPane.pannableProperty();
    }
}

