/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.concurrent.ProgressTracker;
import com.dua3.utility.concurrent.ProgressView;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class ProgressView<T>
extends GridPane
implements ProgressTracker<T> {
    private final com.dua3.utility.concurrent.ProgressView<T> imp;

    public ProgressView() {
        this.setHgap(8.0);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setHgrow(Priority.SOMETIMES);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        this.imp = new com.dua3.utility.concurrent.ProgressView(this::createProgressIndicator);
    }

    private ProgressView.ProgressIndicator createProgressIndicator(T t) {
        assert (t != null) : "t is null";
        FxProgressBarIndicator pi = new FxProgressBarIndicator();
        int row = this.getChildren().size();
        Label label = new Label(t.toString());
        ProgressView.setConstraints((Node)label, (int)0, (int)row);
        ProgressBar pb = pi.pb;
        pb.setMaxWidth(Double.POSITIVE_INFINITY);
        ProgressView.setConstraints((Node)pb, (int)1, (int)row);
        this.getChildren().addAll((Object[])new Node[]{label, pb});
        return pi;
    }

    public void schedule(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.schedule(task);
    }

    public void start(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.update(task, 0, 0);
    }

    public void pause(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.pause(task);
    }

    public void abort(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.abort(task);
    }

    public void finish(T task, ProgressTracker.State s) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.imp.finish(task, s);
    }

    public void update(T task, int total, int done) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.update(task, total, done);
    }

    public void update(T task, double percentDone) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.imp.update(task, percentDone);
    }

    private static class FxProgressBarIndicator
    implements ProgressView.ProgressIndicator {
        private final ProgressBar pb = new ProgressBar();
        static final /* synthetic */ boolean $assertionsDisabled;

        FxProgressBarIndicator() {
        }

        public void finish(ProgressTracker.State s) {
            if (!$assertionsDisabled && s == null) {
                throw new AssertionError((Object)"s is null");
            }
            Platform.runLater(() -> this.pb.setProgress(1.0));
        }

        public void update(int done, int total) {
            Platform.runLater(() -> {
                if (total == 0) {
                    this.pb.setProgress(-1.0);
                } else {
                    this.pb.setProgress((double)done / (double)total);
                }
            });
        }

        public void update(double percentDone) {
            Platform.runLater(() -> this.pb.setProgress(percentDone));
        }

        static {
            $assertionsDisabled = !FxProgressBarIndicator.class.desiredAssertionStatus();
        }
    }
}

