/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.abstract_builders.DialogBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Window;
import org.jspecify.annotations.Nullable;

public class PromptBuilder
extends DialogBuilder<TextInputDialog, PromptBuilder, String> {
    private String defaultValue = "";
    private Predicate<? super @Nullable String> validate = s -> s != null && !s.isEmpty();

    PromptBuilder(@Nullable Window parentWindow) {
        super(parentWindow);
        this.setDialogSupplier(this::createDialog);
    }

    public PromptBuilder defaultValue(String fmt, Object ... args) {
        if (fmt == null) {
            throw new IllegalArgumentException("fmt is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        this.defaultValue = args.length == 0 ? fmt : String.format(fmt, args);
        return this;
    }

    public PromptBuilder validate(Predicate<? super String> validate) {
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        this.validate = validate;
        return this;
    }

    @Override
    public TextInputDialog build() {
        TextInputDialog dlg = (TextInputDialog)super.build();
        dlg.setGraphic(null);
        return dlg;
    }

    private TextInputDialog createDialog() {
        TextInputDialog dlg = new TextInputDialog(this.defaultValue);
        Optional.ofNullable(dlg.getDialogPane().lookupButton(ButtonType.OK)).ifPresent(btn -> {
            btn.setDisable(!this.validate.test(dlg.getEditor().getText()));
            dlg.getEditor().textProperty().addListener((observable, oldValue, newValue) -> btn.setDisable(!this.validate.test((String)newValue)));
        });
        return dlg;
    }
}

