/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.InputControl;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class RadioPane<T>
extends VBox
implements InputControl<T> {
    protected static final Logger LOG = LogManager.getLogger(RadioPane.class);
    private static final double SPACING = 4.0;
    private final LinkedHashMap<T, RadioButton> items;
    private final ToggleGroup group;
    private final InputControl.State<T> state;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public RadioPane(Collection<T> items, @Nullable T currentValue, Function<T, Optional<String>> validate) {
        if (items == null) {
            throw new IllegalArgumentException("items is null");
        }
        if (validate == null) {
            throw new IllegalArgumentException("validate is null");
        }
        this.items = new LinkedHashMap();
        this.group = new ToggleGroup();
        this.setSpacing(4.0);
        ObservableList children = this.getChildren();
        for (T item : items) {
            RadioButton control = new RadioButton(String.valueOf(item));
            control.setUserData(item);
            control.setToggleGroup(this.group);
            children.add((Object)control);
            this.items.put(item, control);
        }
        @Nullable SimpleObjectProperty property = new SimpleObjectProperty();
        this.group.selectedToggleProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$0((Property)property, arg_0, arg_1, arg_2));
        this.state = new InputControl.State(property);
        this.state.setValidate(validate);
        this.state.valueProperty().addListener((v, o, n) -> this.group.selectToggle((Toggle)this.items.get(n)));
        this.group.selectToggle((Toggle)this.items.get(currentValue));
    }

    @Override
    public Node node() {
        return this;
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    @Override
    public Property<@Nullable T> valueProperty() {
        return this.state.valueProperty();
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.state.validProperty();
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return this.state.errorProperty();
    }

    public void requestFocus() {
        Toggle t;
        if (this.group.getToggles().isEmpty()) {
            super.requestFocus();
        }
        if ((t = this.group.getSelectedToggle()) == null) {
            t = (Toggle)this.group.getToggles().get(0);
        }
        if (t instanceof Control) {
            ((Control)t).requestFocus();
        } else {
            super.requestFocus();
        }
    }

    private /* synthetic */ void lambda$new$0(Property property, ObservableValue v, Toggle o, Toggle n) {
        Toggle toggle = this.group.getSelectedToggle();
        property.setValue(toggle != null ? toggle.getUserData() : null);
    }
}

