/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.SliderWithButtons;
import java.util.function.BiFunction;
import java.util.function.DoubleConsumer;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;

public class SliderBuilder {
    private final SliderWithButtons slider;

    SliderBuilder(SliderWithButtons.Mode mode, BiFunction<Double, Double, String> formatter) {
        if (!$assertionsDisabled) {
            if (mode == null) {
                throw new AssertionError((Object)"mode is null");
            }
            if (formatter == null) {
                throw new AssertionError((Object)"formatter is null");
            }
        }
        this.slider = new SliderWithButtons(mode, formatter);
    }

    public SliderBuilder orientation(Orientation value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.setOrientation(value);
        return this;
    }

    public SliderBuilder min(double value) {
        this.slider.setMin(value);
        return this;
    }

    public SliderBuilder max(double value) {
        this.slider.setMax(value);
        return this;
    }

    public SliderBuilder value(double value) {
        this.slider.setValue(value);
        return this;
    }

    public SliderBuilder incrementText(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.setIncrementText(value);
        return this;
    }

    public SliderBuilder incrementGraphic(Node value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.setIncrementGraphic(value);
        return this;
    }

    public SliderBuilder decrementText(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.setDecrementText(value);
        return this;
    }

    public SliderBuilder decrementGraphic(Node value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.setDecrementGraphic(value);
        return this;
    }

    public SliderBuilder blockIncrement(double value) {
        this.slider.setBlockIncrement(value);
        return this;
    }

    public SliderBuilder showTickLabels(boolean value) {
        this.slider.setShowTickLabels(value);
        return this;
    }

    public SliderBuilder showTickMarks(boolean value) {
        this.slider.setShowTickMarks(value);
        return this;
    }

    public SliderBuilder onChange(DoubleConsumer onChange) {
        if (onChange == null) {
            throw new IllegalArgumentException("onChange is null");
        }
        this.slider.valueProperty().addListener((v, o, n) -> onChange.accept(n.doubleValue()));
        return this;
    }

    public SliderBuilder bind(Property<Number> value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.valueProperty().bindBidirectional(value);
        return this;
    }

    public SliderBuilder bindMin(ObservableNumberValue value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.minProperty().bind((ObservableValue)value);
        return this;
    }

    public SliderBuilder bindMax(ObservableNumberValue value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.slider.maxProperty().bind((ObservableValue)value);
        return this;
    }

    public SliderWithButtons build() {
        return this.slider;
    }
}

