/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import org.jspecify.annotations.Nullable;

public class SliderWithButtons
extends Region {
    private static final Pattern PATTERN_DIGIT = Pattern.compile("\\d");
    private final Mode mode;
    private final BiFunction<? super Double, Double, String> formatter;
    private final Slider slider;
    private final Button btnIncrement;
    private final Button btnDecrement;
    private final List<Node> children;
    private @Nullable TextField tfValue;
    private @Nullable Label label;

    SliderWithButtons(Mode mode, BiFunction<? super Double, Double, String> formatter) {
        if (!$assertionsDisabled) {
            if (mode == null) {
                throw new AssertionError((Object)"mode is null");
            }
            if (formatter == null) {
                throw new AssertionError((Object)"formatter is null");
            }
        }
        this.children = new ArrayList<Node>();
        this.mode = mode;
        this.formatter = formatter;
        this.slider = new Slider();
        this.btnDecrement = new Button("-");
        this.btnIncrement = new Button("+");
        this.btnDecrement.setOnAction(evt -> this.slider.decrement());
        this.btnDecrement.setFocusTraversable(false);
        this.children.add((Node)this.btnDecrement);
        this.children.add((Node)this.slider);
        this.btnIncrement.setOnAction(evt -> this.slider.increment());
        this.btnIncrement.setFocusTraversable(false);
        this.children.add((Node)this.btnIncrement);
        switch (mode.ordinal()) {
            case 0: {
                this.tfValue = null;
                this.label = null;
                break;
            }
            case 1: 
            case 2: {
                this.tfValue = null;
                this.label = new Label();
                this.children.add((Node)this.label);
                break;
            }
            case 3: {
                this.tfValue = new TextField();
                this.children.add((Node)this.tfValue);
                this.label = new Label();
                this.children.add((Node)this.label);
            }
        }
        this.slider.valueProperty().addListener((v, o, n) -> this.valueChanged((Number)o, (Number)n));
        this.slider.maxProperty().addListener((v, o, n) -> this.updateLabel());
        this.initPane();
    }

    private void valueChanged(Number o, Number n) {
        if (!$assertionsDisabled) {
            if (o == null) {
                throw new AssertionError((Object)"o is null");
            }
            if (n == null) {
                throw new AssertionError((Object)"n is null");
            }
        }
        if (this.label != null) {
            this.label.setText(this.formatter.apply((Double)n.doubleValue(), this.getMax()));
        }
        if (this.tfValue != null) {
            this.tfValue.setText(String.valueOf(n));
        }
    }

    private void updateLabel() {
        if (this.label == null) {
            return;
        }
        double v = this.getValue();
        double m = this.getMax();
        String proto = PATTERN_DIGIT.matcher(this.formatter.apply((Double)m, m)).replaceAll("0");
        Text text = new Text(proto);
        text.setFont(this.label.getFont());
        double w = text.getBoundsInLocal().getWidth();
        int paddingLeft = 2;
        int paddingRight = 4;
        this.label.setMinWidth(w + (double)paddingLeft + (double)paddingRight);
        this.label.setPadding(new Insets(0.0, (double)paddingRight, 0.0, (double)paddingLeft));
        this.valueChanged(v, v);
    }

    private void initPane() {
        Pane pane = SliderWithButtons.box(this.slider.getOrientation());
        pane.getChildren().addAll(this.children);
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    public double getMax() {
        return this.slider.getMax();
    }

    public void setMax(double value) {
        this.slider.setMax(value);
    }

    public double getValue() {
        return this.slider.getValue();
    }

    private static Pane box(Orientation orientation) {
        assert (orientation != null) : "orientation is null";
        if (orientation == Orientation.HORIZONTAL) {
            HBox box = new HBox();
            box.setAlignment(Pos.CENTER);
            return box;
        }
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        return box;
    }

    public void setValue(double value) {
        this.slider.setValue(value);
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        if (orientation != this.slider.getOrientation()) {
            this.slider.setOrientation(orientation);
            this.initPane();
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDecrementText(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.btnDecrement.setText(value);
    }

    public void setDecrementGraphic(Node value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.btnDecrement.setGraphic(value);
    }

    public void setIncrementText(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.btnIncrement.setText(value);
    }

    public void setIncrementGraphic(Node value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.btnIncrement.setGraphic(value);
    }

    public void setShowTickLabels(boolean value) {
        this.slider.setShowTickLabels(value);
    }

    public void setShowTickMarks(boolean value) {
        this.slider.setShowTickMarks(value);
    }

    public double getMin() {
        return this.slider.getMin();
    }

    public void setMin(double value) {
        this.slider.setMin(value);
    }

    public double getMajorTickUnit() {
        return this.slider.getMajorTickUnit();
    }

    public double getMinorTickCount() {
        return this.slider.getMinorTickCount();
    }

    public double getBlockIncrement() {
        return this.slider.getBlockIncrement();
    }

    public void setBlockIncrement(double value) {
        this.slider.setBlockIncrement(value);
    }

    public DoubleProperty valueProperty() {
        return this.slider.valueProperty();
    }

    public DoubleProperty minProperty() {
        return this.slider.minProperty();
    }

    public DoubleProperty maxProperty() {
        return this.slider.maxProperty();
    }

    public DoubleProperty majorTickUnitProperty() {
        return this.slider.majorTickUnitProperty();
    }

    public IntegerProperty minorTickCountProperty() {
        return this.slider.minorTickCountProperty();
    }

    public BooleanProperty valueChangingProperty() {
        return this.slider.valueChangingProperty();
    }

    public ObjectProperty<StringConverter<Double>> labelFormatterProperty() {
        return this.slider.labelFormatterProperty();
    }

    public BooleanProperty showTickLabelsProperty() {
        return this.slider.showTickLabelsProperty();
    }

    public BooleanProperty showTickMarksProperty() {
        return this.slider.showTickMarksProperty();
    }

    public BooleanProperty snapToTicksProperty() {
        return this.slider.snapToTicksProperty();
    }

    public static enum Mode {
        SLIDER_ONLY,
        SLIDER_VALUE,
        SLIDER_VALUE_TOTAL,
        SLIDER_INPUT_TOTAL;

    }
}

