/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxTaskTracker;
import com.dua3.utility.fx.PlatformHelper;
import com.dua3.utility.fx.controls.CustomControl;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusBar
extends CustomControl<HBox>
implements FxTaskTracker {
    private static final Logger LOG = LogManager.getLogger(StatusBar.class);
    Label text;
    ProgressBar progressBar;

    public StatusBar() {
        super(new HBox());
        ((HBox)this.container).setAlignment(Pos.CENTER_LEFT);
        this.getStyleClass().setAll((Object[])new String[]{"statusbar"});
        this.text = new Label();
        this.progressBar = new ProgressBar(0.0);
        HBox.setHgrow((Node)this.text, (Priority)Priority.ALWAYS);
        this.progressBar.setPrefWidth(100.0);
        Region region = new Region();
        region.setPrefHeight(1.0);
        region.setPrefWidth(4.0);
        ((HBox)this.container).getChildren().setAll((Object[])new Node[]{this.text, region, this.progressBar});
    }

    public void setText(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        PlatformHelper.runLater(() -> this.text.setText(s));
    }

    public void setProgress(double p) {
        PlatformHelper.runLater(() -> this.progressBar.setProgress(p));
    }

    public void updateTaskState(Task<?> task, Worker.State state) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (state == null) {
            throw new IllegalArgumentException("state is null");
        }
        PlatformHelper.runLater(() -> {
            switch (state) {
                case RUNNING: {
                    this.progressBar.setProgress(-1.0);
                    this.progressBar.setVisible(true);
                    break;
                }
                case SUCCEEDED: {
                    this.progressBar.setProgress(1.0);
                    this.progressBar.setVisible(false);
                    break;
                }
                case READY: 
                case CANCELLED: 
                case FAILED: {
                    this.progressBar.setProgress(0.0);
                    this.progressBar.setVisible(false);
                    break;
                }
                case SCHEDULED: {
                    this.progressBar.setProgress(0.0);
                    this.progressBar.setVisible(true);
                    break;
                }
                default: {
                    LOG.warn("StatusBar.updateTaskState() - unexpected state: {}", (Object)state);
                }
            }
        });
    }

    public void updateTaskProgress(Task<?> task, double p) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.progressBar.setProgress(p);
    }

    public void updateTaskTitle(Task<?> task, String s) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.text.setText(s);
    }

    public void updateTaskMessage(Task<?> task, String s) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.progressBar.setTooltip(new Tooltip(s));
    }
}

