/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import java.util.Objects;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.jspecify.annotations.Nullable;

public class TableCellAutoCommit<S, T>
extends TableCell<S, T> {
    private final TextField textField;
    private final StringConverter<? super T> converter;

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return TableCellAutoCommit.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        return list -> new TableCellAutoCommit(converter);
    }

    public TableCellAutoCommit(StringConverter<T> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        this.textField = new TextField();
        this.converter = converter;
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.itemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.setText(null);
            } else {
                this.setText(converter.toString(newValue));
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case ESCAPE: {
                    this.textField.setText(converter.toString(this.getItem()));
                    this.cancelEdit();
                    event.consume();
                    break;
                }
                case RIGHT: {
                    this.getTableView().getSelectionModel().selectRightCell();
                    event.consume();
                    break;
                }
                case LEFT: {
                    this.getTableView().getSelectionModel().selectLeftCell();
                    event.consume();
                    break;
                }
                case UP: {
                    this.getTableView().getSelectionModel().selectAboveCell();
                    event.consume();
                    break;
                }
                case DOWN: {
                    this.getTableView().getSelectionModel().selectBelowCell();
                    event.consume();
                    break;
                }
            }
        });
        this.textField.setOnAction(evt -> this.commitEdit(converter.fromString(this.textField.getText())));
        this.textField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.commitEdit(converter.fromString(this.textField.getText()));
            }
        });
    }

    public void startEdit() {
        super.startEdit();
        this.textField.setText(this.converter.toString(this.getItem()));
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void commitEdit(@Nullable T newValue) {
        TableView table;
        if (!this.isEditing() && !Objects.equals(newValue, this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn column = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), column), TableColumn.editCommitEvent(), newValue);
            Event.fireEvent((EventTarget)column, (Event)event);
            Platform.runLater(() -> ((TableView)table).refresh());
        }
        super.commitEdit(newValue);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }
}

