/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Color;
import com.dua3.utility.data.Converter;
import com.dua3.utility.fx.FxFontUtil;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PropertyConverter;
import com.dua3.utility.fx.controls.abstract_builders.ShapeBuilder;
import com.dua3.utility.text.Font;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.jspecify.annotations.Nullable;

public class TextBuilder
extends ShapeBuilder<Text, TextBuilder> {
    private final ObservableValue<String> text;
    private @Nullable ObservableValue<javafx.scene.text.Font> font;
    private @Nullable ObservableValue<? extends Paint> fill;

    protected TextBuilder(String text) {
        assert (text != null) : "text is null";
        super(Text::new);
        this.font = null;
        this.fill = null;
        this.text = new SimpleStringProperty(text);
    }

    protected TextBuilder(ObservableValue<String> text) {
        assert (text != null) : "text is null";
        super(Text::new);
        this.font = null;
        this.fill = null;
        this.text = text;
    }

    @Override
    public Text build() {
        Text node = (Text)super.build();
        this.apply(this.text, node.textProperty());
        this.apply(this.font, node.fontProperty());
        this.apply(this.fill, node.fillProperty());
        return node;
    }

    @Override
    public TextBuilder fill(Paint fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = new SimpleObjectProperty((Object)fill);
        return (TextBuilder)this.self();
    }

    @Override
    public TextBuilder fill(Color fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = new SimpleObjectProperty((Object)FxUtil.convert((Color)fill));
        return (TextBuilder)this.self();
    }

    @Override
    public TextBuilder bindFillFx(ObservableValue<Paint> fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = fill;
        return (TextBuilder)this.self();
    }

    @Override
    public TextBuilder bindFill(ObservableValue<Color> fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = PropertyConverter.convertReadOnly(fill, (Converter)FxUtil.colorConverter());
        return (TextBuilder)this.self();
    }

    public TextBuilder font(javafx.scene.text.Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)font);
        return (TextBuilder)this.self();
    }

    public TextBuilder font(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)FxFontUtil.getInstance().convert(font));
        this.fill = new SimpleObjectProperty((Object)FxUtil.convert((Color)font.getColor()));
        return (TextBuilder)this.self();
    }

    public TextBuilder bindFontFx(ObservableValue<javafx.scene.text.Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = font;
        return (TextBuilder)this.self();
    }

    public TextBuilder bindFont(ObservableValue<Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = PropertyConverter.convertReadOnly(font, (Converter)FxUtil.fontConverter());
        this.fill = PropertyConverter.convertReadOnly(font, f -> FxUtil.convert((Color)f.getColor()));
        return (TextBuilder)this.self();
    }
}

