/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.TextFieldType;
import com.dua3.utility.lang.LangUtil;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.BigDecimalStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.jspecify.annotations.Nullable;

public final class TextFieldBuilder {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d*|0");
    private static final UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TextFormatter.Change> INTEGER_FILTER = change -> INTEGER_PATTERN.matcher(change.getControlNewText()).matches() ? change : null;
    private static final Pattern SIGNED_INTEGER_PATTERN = Pattern.compile("-?([1-9]\\d*|0)?");
    private static final UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TextFormatter.Change> SIGNED_INTEGER_FILTER = change -> SIGNED_INTEGER_PATTERN.matcher(change.getControlNewText()).matches() ? change : null;
    private final Pattern floatPattern;
    private final UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TextFormatter.Change> floatFilter;
    private final Locale locale;
    private @Nullable String text;
    private TextFieldType type;
    private @Nullable ObservableValue<Boolean> disabled;

    private static TextFormatter<Integer> getIntegerTextFormatter(UnaryOperator<TextFormatter.Change> filter) {
        assert (filter != null) : "filter is null";
        return new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)0, filter);
    }

    private TextFormatter<BigDecimal> getFloatTextFormatter(UnaryOperator<TextFormatter.Change> filter) {
        assert (filter != null) : "filter is null";
        return new TextFormatter((StringConverter)new BigDecimalStringConverter(), (Object)BigDecimal.ZERO, filter);
    }

    TextFieldBuilder(Locale locale) {
        assert (locale != null) : "locale is null";
        this.type = TextFieldType.TEXT;
        this.locale = locale;
        this.floatPattern = this.getFloatPattern();
        this.floatFilter = change -> this.floatPattern.matcher(change.getControlNewText()).matches() ? change : null;
    }

    private Pattern getFloatPattern() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale);
        char decimalSeparator = symbols.getDecimalSeparator();
        char groupingSeparator = symbols.getGroupingSeparator();
        String escapedDecimalSeparator = Pattern.quote(String.valueOf(decimalSeparator));
        String escapedGroupingSeparator = Pattern.quote(String.valueOf(groupingSeparator));
        return Pattern.compile("[+-]?([0-9" + escapedGroupingSeparator + "]*" + escapedDecimalSeparator + ")?[0-9]+");
    }

    public TextFieldBuilder text(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        this.text = text;
        return this;
    }

    public TextFieldBuilder type(TextFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
        return this;
    }

    public TextFieldBuilder bindDisabled(ObservableBooleanValue disabled) {
        if (disabled == null) {
            throw new IllegalArgumentException("disabled is null");
        }
        LangUtil.check((this.disabled == null ? 1 : 0) != 0, (String)"the disabled property has already been bound to a value", (Object[])new Object[0]);
        this.disabled = disabled;
        return this;
    }

    public TextField build() {
        TextField tf = new TextField();
        switch (this.type) {
            case INTEGER: {
                tf.setTextFormatter(TextFieldBuilder.getIntegerTextFormatter(INTEGER_FILTER));
                break;
            }
            case SIGNED_INTEGER: {
                tf.setTextFormatter(TextFieldBuilder.getIntegerTextFormatter(SIGNED_INTEGER_FILTER));
                break;
            }
            case FLOAT: {
                tf.setTextFormatter(this.getFloatTextFormatter(this.floatFilter));
                break;
            }
        }
        if (this.text != null) {
            tf.setText(this.text);
        }
        if (this.disabled != null) {
            tf.disableProperty().bind(this.disabled);
        }
        return tf;
    }
}

