/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.abstract_builders.ButtonBaseBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.control.ToggleButton;

public class ToggleButtonBuilder
extends ButtonBaseBuilder<ToggleButton, ToggleButtonBuilder> {
    private final List<Property<Boolean>> selectedList;

    ToggleButtonBuilder(Supplier<? extends ToggleButton> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
        this.selectedList = new ArrayList<Property<Boolean>>();
    }

    public ToggleButtonBuilder bindSelected(Property<Boolean> selected) {
        if (selected == null) {
            throw new IllegalArgumentException("selected is null");
        }
        this.selectedList.add(selected);
        return (ToggleButtonBuilder)this.self();
    }

    @Override
    public ToggleButton build() {
        ToggleButton button = (ToggleButton)super.build();
        this.selectedList.forEach(selected -> Bindings.bindBidirectional((Property)selected, (Property)button.selectedProperty()));
        return button;
    }
}

