/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import javafx.scene.control.Tooltip;
import javafx.util.Duration;

public record TooltipConfig(Duration showDelay, Duration showDuration, Duration hideDelay) {
    private static final TooltipConfig DEFAULT_CONFIG = TooltipConfig.from(new Tooltip());

    public TooltipConfig {
        if (showDelay == null) {
            throw new IllegalArgumentException("showDelay is null");
        }
        if (showDuration == null) {
            throw new IllegalArgumentException("showDuration is null");
        }
        if (hideDelay == null) {
            throw new IllegalArgumentException("hideDelay is null");
        }
    }

    public static TooltipConfig getDefault() {
        return DEFAULT_CONFIG;
    }

    public void applyTo(Tooltip tt) {
        if (tt == null) {
            throw new IllegalArgumentException("tt is null");
        }
        tt.setShowDelay(this.showDelay);
        tt.setShowDuration(this.showDuration);
        tt.setHideDelay(this.hideDelay);
    }

    public static TooltipConfig from(Tooltip tt) {
        if (tt == null) {
            throw new IllegalArgumentException("tt is null");
        }
        return new TooltipConfig(tt.getShowDelay(), tt.getShowDuration(), tt.getHideDelay());
    }
}

