/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Pair;
import com.dua3.utility.fx.controls.InputDialogPane;
import com.dua3.utility.fx.controls.abstract_builders.DialogPaneBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class WizardDialog
extends Dialog<Map<String, Object>> {
    private static final Logger LOG = LogManager.getLogger(WizardDialog.class);
    private final ObservableList<Pair<String, Page<?, ?>>> pageStack = FXCollections.observableArrayList();
    private boolean cancelable = true;
    private boolean showPreviousButton = true;
    private @Nullable Map<String, Page<?, ?>> pages;
    private @Nullable Pair<String, Page<?, ?>> current;

    public WizardDialog() {
        this.setResultConverter(btn -> {
            if (btn != ButtonType.FINISH) {
                return null;
            }
            this.pageStack.add(Objects.requireNonNull(this.current, "no pages"));
            LinkedHashMap result = new LinkedHashMap();
            this.pageStack.forEach(p -> {
                assert (((Page)p.second()).result != null);
                result.put((String)p.first(), ((Page)p.second()).result);
            });
            return result;
        });
    }

    public void setPages(Map<String, Page<?, ?>> pages, String startPage) {
        if (pages == null) {
            throw new IllegalArgumentException("pages is null");
        }
        if (startPage == null) {
            throw new IllegalArgumentException("startPage is null");
        }
        this.pages = pages;
        this.checkPages();
        this.setPage(startPage);
    }

    private void checkPages() {
        if (this.pages == null) {
            return;
        }
        Set<String> pageNames = this.pages.keySet();
        for (Map.Entry<String, Page<?, ?>> entry : this.pages.entrySet()) {
            String name = entry.getKey();
            Page<?, ?> page = entry.getValue();
            Object pane = page.getPane();
            String next = page.getNext();
            if (next != null && !pageNames.contains(next)) {
                throw new IllegalStateException(String.format("Page '%s': next page doesn't exist ['%s']", name, next));
            }
            if (this.isCancelable()) {
                page.addButton(ButtonType.CANCEL, p -> {}, null);
            }
            if (page.getNext() == null) {
                page.addButton(ButtonType.FINISH, p -> {}, (BooleanExpression)((InputDialogPane)pane).validProperty());
            } else {
                page.addButton(ButtonType.NEXT, p -> {
                    this.pageStack.add((Object)Pair.of((Object)name, (Object)page));
                    this.setPage(page.getNext());
                }, (BooleanExpression)((InputDialogPane)pane).validProperty());
            }
            if (!this.isShowPreviousButton()) continue;
            page.addButton(ButtonType.PREVIOUS, p -> this.setPage((String)((Pair)this.pageStack.remove(this.pageStack.size() - 1)).first()), (BooleanExpression)Bindings.isNotEmpty(this.pageStack));
        }
    }

    private void setPage(String pageName) {
        assert (pageName != null) : "pageName is null";
        this.current = Pair.of((Object)pageName, Objects.requireNonNull(this.pages, "pages not set").get(pageName));
        Object pane = ((Page)this.current.second()).pane;
        this.setDialogPane((DialogPane)pane);
        ((InputDialogPane)pane).init();
        pane.layout();
        pane.getScene().getWindow().sizeToScene();
        LOG.debug("current page: {}", (Object)pageName);
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public boolean isShowPreviousButton() {
        return this.showPreviousButton;
    }

    public Optional<Page<?, ?>> getCurrentPage() {
        return Optional.ofNullable(this.current).map(Pair::second);
    }

    public static class Page<D extends InputDialogPane<R>, R> {
        private final D pane;
        private final DialogPaneBuilder.ResultHandler<R> resultHandler;
        private @Nullable String next;
        private @Nullable R result;

        Page(D pane, DialogPaneBuilder.ResultHandler<R> resultHandler) {
            if (!$assertionsDisabled) {
                if (pane == null) {
                    throw new AssertionError((Object)"pane is null");
                }
                if (resultHandler == null) {
                    throw new AssertionError((Object)"resultHandler is null");
                }
            }
            this.pane = pane;
            this.resultHandler = (btn, result) -> {
                boolean ok = resultHandler.handleResult(btn, result);
                this.result = result;
                return ok;
            };
        }

        @Nullable String getNext() {
            return this.next;
        }

        void setNext(@Nullable String next) {
            this.next = next;
        }

        D getPane() {
            return this.pane;
        }

        public void addButton(ButtonType type, Consumer<InputDialogPane<R>> action, @Nullable BooleanExpression enabled) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            if (action == null) {
                throw new IllegalArgumentException("action is null");
            }
            ((InputDialogPane)this.pane).addButton(type, this.resultHandler, action, enabled);
        }
    }
}

