/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.InputDialogPane;
import com.dua3.utility.fx.controls.WizardDialog;
import com.dua3.utility.fx.controls.abstract_builders.DialogPaneBuilder;
import com.dua3.utility.fx.controls.abstract_builders.PaneBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class WizardDialogBuilder {
    final LinkedHashMap<String, WizardDialog.Page<?, ?>> pages = new LinkedHashMap();
    private String title = "";
    private String startPage = "";

    WizardDialogBuilder() {
    }

    public WizardDialogBuilder title(String title) {
        if (title == null) {
            throw new IllegalArgumentException("title is null");
        }
        this.title = title;
        return this;
    }

    public <D extends InputDialogPane<R>, B extends PaneBuilder<D, B, R>, R> WizardDialogBuilder page(String name, B builder) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("builder is null");
        }
        InputDialogPane pane = (InputDialogPane)builder.build();
        DialogPaneBuilder.ResultHandler resultHandler = builder.getResultHandler();
        WizardDialog.Page page = new WizardDialog.Page(pane, resultHandler);
        page.setNext(builder.getNext().orElse(null));
        this.pages.put(name, page);
        if (this.startPage.isEmpty()) {
            this.setStartPage(name);
        }
        return this;
    }

    public Optional<Map<String, Object>> showAndWait() {
        return this.build().showAndWait();
    }

    public WizardDialog build() {
        WizardDialog dlg = new WizardDialog();
        WizardDialog.Page<?, ?> prev = null;
        for (Map.Entry<String, WizardDialog.Page<?, ?>> entry : this.pages.entrySet()) {
            String name = entry.getKey();
            WizardDialog.Page<?, ?> page = entry.getValue();
            if (prev != null && prev.getNext() == null) {
                prev.setNext(name);
            }
            prev = page;
        }
        dlg.setTitle(this.title);
        dlg.setPages(new LinkedHashMap(this.pages), this.getStartPage());
        return dlg;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        if (startPage == null) {
            throw new IllegalArgumentException("startPage is null");
        }
        this.startPage = startPage;
    }
}

