/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.fx.PropertyConverter;
import com.dua3.utility.fx.controls.abstract_builders.LabeledBuilder;
import java.util.function.Supplier;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonBase;
import org.jspecify.annotations.Nullable;

public abstract class ButtonBaseBuilder<B extends ButtonBase, BB extends ButtonBaseBuilder<B, BB>>
extends LabeledBuilder<B, BB> {
    private @Nullable ObservableValue<EventHandler<ActionEvent>> action;

    protected ButtonBaseBuilder(Supplier<? extends B> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
    }

    @Override
    public B build() {
        ButtonBase node = (ButtonBase)super.build();
        this.apply(this.action, node.onActionProperty());
        return (B)node;
    }

    public BB action(EventHandler<ActionEvent> action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        this.action = new SimpleObjectProperty(action);
        return (BB)((ButtonBaseBuilder)this.self());
    }

    public BB action(Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        return this.action((EventHandler<ActionEvent>)((EventHandler)evt -> action.run()));
    }

    public BB bindAction(EventHandler<ActionEvent> action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        this.action = new SimpleObjectProperty(action);
        return (BB)((ButtonBaseBuilder)this.self());
    }

    public BB bindAction(ObservableValue<Runnable> action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        this.action = PropertyConverter.convertReadOnly(action, r -> event -> r.run());
        return (BB)((ButtonBaseBuilder)this.self());
    }
}

