/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.fx.controls.abstract_builders.NodeBuilder;
import java.util.function.Supplier;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import org.jspecify.annotations.Nullable;

public abstract class ControlBuilder<N extends Control, NN extends ControlBuilder<N, NN>>
extends NodeBuilder<N, NN> {
    private @Nullable ObservableValue<String> tooltip;

    protected ControlBuilder(Supplier<? extends N> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
    }

    @Override
    public N build() {
        Control node = (Control)super.build();
        this.apply(this.tooltip, (T t) -> {
            Tooltip tt = new Tooltip();
            tt.textProperty().bind(t);
            node.setTooltip(tt);
        });
        return (N)node;
    }

    public NN tooltip(String tooltip) {
        if (tooltip == null) {
            throw new IllegalArgumentException("tooltip is null");
        }
        this.tooltip = new SimpleStringProperty(tooltip);
        return (NN)((ControlBuilder)this.self());
    }

    public NN bindTooltip(ObservableValue<String> tooltip) {
        if (tooltip == null) {
            throw new IllegalArgumentException("tooltip is null");
        }
        this.tooltip = tooltip;
        return (NN)((ControlBuilder)this.self());
    }
}

