/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.fx.controls.abstract_builders.DialogPaneBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.scene.control.Dialog;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class DialogBuilder<D extends @NonNull Dialog<R>, B extends @NonNull DialogBuilder<D, B, R>, R>
extends DialogPaneBuilder<D, B, R> {
    private final BiConsumer<D, String> titleSetter;
    private final @Nullable Window parentWindow;
    private @Nullable String title;

    protected DialogBuilder(@Nullable Window parentWindow) {
        super(Dialog::setHeaderText);
        this.parentWindow = parentWindow;
        this.titleSetter = Dialog::setTitle;
    }

    public B title(String fmt, Object ... args) {
        if (fmt == null) {
            throw new IllegalArgumentException("fmt is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        this.title = String.format(fmt, args);
        return (B)this;
    }

    public Optional<R> showAndWait() {
        return this.build().showAndWait();
    }

    @Override
    public D build() {
        Dialog dlg = (Dialog)super.build();
        if (this.parentWindow != null) {
            Stage stage = (Stage)dlg.getDialogPane().getScene().getWindow();
            stage.getIcons().addAll((Collection)((Stage)this.parentWindow).getIcons());
        }
        DialogBuilder.applyIfNotNull(this.titleSetter, dlg, this.title);
        return (D)dlg;
    }
}

