/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.fx.controls.InputDialogPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.control.ButtonType;
import org.jspecify.annotations.Nullable;

public abstract class DialogPaneBuilder<D, B extends DialogPaneBuilder<D, B, R>, R> {
    public static final BooleanExpression ALWAYS_TRUE = new ReadOnlyBooleanWrapper(true);
    private final BiConsumer<? super D, ? super String> headerSetter;
    private Supplier<? extends D> dialogSupplier;
    private @Nullable String header;
    private ResultHandler<R> resultHandler;
    private final List<InputDialogPane.ButtonDef<R>> buttons;

    protected DialogPaneBuilder(BiConsumer<? super D, ? super String> headerSetter) {
        assert (headerSetter != null) : "headerSetter is null";
        this.header = null;
        this.resultHandler = (b, r) -> true;
        this.buttons = new ArrayList<InputDialogPane.ButtonDef<R>>();
        this.dialogSupplier = () -> {
            throw new IllegalStateException("call setDialogSupplier() first");
        };
        this.headerSetter = headerSetter;
    }

    protected final void setDialogSupplier(Supplier<? extends D> dialogSupplier) {
        assert (dialogSupplier != null) : "dialogSupplier is null";
        this.dialogSupplier = dialogSupplier;
    }

    public D build() {
        D dlg = this.dialogSupplier.get();
        DialogPaneBuilder.applyIfNotNull(this.headerSetter, dlg, this.header);
        return dlg;
    }

    protected static <C, D> void applyIfNotNull(BiConsumer<C, D> consumer, @Nullable C a, @Nullable D b) {
        assert (consumer != null) : "consumer is null";
        if (a != null && b != null) {
            consumer.accept(a, b);
        }
    }

    public B header(String fmt, Object ... args) {
        if (fmt == null) {
            throw new IllegalArgumentException("fmt is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        this.header = String.format(fmt, args);
        return (B)this;
    }

    public B resultHandler(ResultHandler<R> resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException("resultHandler is null");
        }
        this.resultHandler = resultHandler;
        return (B)this;
    }

    public ResultHandler<R> getResultHandler() {
        return this.resultHandler;
    }

    protected B button(InputDialogPane.ButtonDef<R> button) {
        assert (button != null) : "button is null";
        this.buttons.add(button);
        return (B)this;
    }

    public List<InputDialogPane.ButtonDef<R>> buttons() {
        if (this.buttons.isEmpty()) {
            return List.of(new InputDialogPane.ButtonDef<Object>(ButtonType.CANCEL, (btn, r) -> true, dlg -> {}, ALWAYS_TRUE), new InputDialogPane.ButtonDef<Object>(ButtonType.OK, (btn, r) -> true, dlg -> {}, ALWAYS_TRUE));
        }
        return Collections.unmodifiableList(this.buttons);
    }

    @FunctionalInterface
    public static interface ResultHandler<R> {
        public boolean handleResult(ButtonType var1, R var2);
    }
}

