/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.data.Converter;
import com.dua3.utility.fx.FxFontUtil;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PropertyConverter;
import com.dua3.utility.fx.controls.abstract_builders.ControlBuilder;
import com.dua3.utility.text.Font;
import java.util.function.Supplier;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import org.jspecify.annotations.Nullable;

public abstract class LabeledBuilder<N extends Labeled, NN extends LabeledBuilder<N, NN>>
extends ControlBuilder<N, NN> {
    private @Nullable ObservableValue<String> text;
    private @Nullable ObservableValue<javafx.scene.text.Font> font;
    private @Nullable ObservableValue<Node> graphic;

    protected LabeledBuilder(Supplier<? extends N> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
        this.font = null;
    }

    @Override
    public N build() {
        Labeled node = (Labeled)super.build();
        this.apply(this.text, node.textProperty());
        this.apply(this.graphic, node.graphicProperty());
        this.apply(this.font, node.fontProperty());
        return (N)node;
    }

    public NN text(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        this.text = new SimpleStringProperty(text);
        return (NN)((LabeledBuilder)this.self());
    }

    public NN bindText(ObservableValue<String> text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        this.text = text;
        return (NN)((LabeledBuilder)this.self());
    }

    public NN graphic(Node graphic) {
        if (graphic == null) {
            throw new IllegalArgumentException("graphic is null");
        }
        this.graphic = new SimpleObjectProperty((Object)graphic);
        return (NN)((LabeledBuilder)this.self());
    }

    public NN graphic(ObservableValue<Node> graphic) {
        if (graphic == null) {
            throw new IllegalArgumentException("graphic is null");
        }
        this.graphic = graphic;
        return (NN)((LabeledBuilder)this.self());
    }

    public NN font(javafx.scene.text.Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)font);
        return (NN)((LabeledBuilder)this.self());
    }

    public NN font(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = new SimpleObjectProperty((Object)FxFontUtil.getInstance().convert(font));
        return (NN)((LabeledBuilder)this.self());
    }

    public NN bindFxFont(ObservableValue<javafx.scene.text.Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = font;
        return (NN)((LabeledBuilder)this.self());
    }

    public NN bindFont(ObservableValue<Font> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        this.font = PropertyConverter.convertReadOnly(font, (Converter)FxUtil.fontConverter());
        return (NN)((LabeledBuilder)this.self());
    }
}

