/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.jspecify.annotations.Nullable;

public abstract class NodeBuilder<N extends Node, NN extends NodeBuilder<N, NN>> {
    private final Supplier<? extends N> factory;
    private @Nullable ObservableValue<Boolean> disabled;
    private @Nullable Double width;
    private @Nullable Double height;

    protected NodeBuilder(Supplier<? extends N> factory) {
        assert (factory != null) : "factory is null";
        this.disabled = null;
        this.width = null;
        this.height = null;
        this.factory = factory;
    }

    protected final NN self() {
        return (NN)this;
    }

    protected final <T> void apply(@Nullable T value, Consumer<T> setter) {
        assert (setter != null) : "setter is null";
        if (value != null) {
            setter.accept(value);
        }
    }

    protected final <T> void apply(@Nullable ObservableValue<? extends T> value, Property<? super T> property) {
        assert (property != null) : "property is null";
        if (value != null) {
            if (value instanceof Property) {
                Property valueProperty = (Property)value;
                property.bindBidirectional(valueProperty);
            } else {
                property.bind(value);
            }
        }
    }

    public N build() {
        Node node = (Node)this.factory.get();
        this.apply((ObservableValue)this.disabled, (Property)node.disableProperty());
        this.apply(this.width, arg_0 -> ((Node)node).prefWidth(arg_0));
        this.apply(this.height, arg_0 -> ((Node)node).prefHeight(arg_0));
        return (N)node;
    }

    public NN disabled(boolean disabled) {
        this.disabled = new SimpleBooleanProperty(disabled);
        return this.self();
    }

    public NN bindDisabled(ObservableValue<Boolean> disabled) {
        if (disabled == null) {
            throw new IllegalArgumentException("disabled is null");
        }
        this.disabled = disabled;
        return this.self();
    }

    public NN bindEnabled(ObservableValue<Boolean> enabled) {
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is null");
        }
        this.disabled = Bindings.createBooleanBinding(() -> (Boolean)enabled.getValue() == false, (Observable[])new Observable[]{enabled});
        return this.self();
    }

    public NN prefWidth(double width) {
        this.width = width;
        return this.self();
    }

    public NN prefHeight(double height) {
        this.height = height;
        return this.self();
    }

    public NN prefSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this.self();
    }
}

