/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls.abstract_builders;

import com.dua3.utility.data.Color;
import com.dua3.utility.data.Converter;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PropertyConverter;
import com.dua3.utility.fx.controls.abstract_builders.NodeBuilder;
import java.util.function.Supplier;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import org.jspecify.annotations.Nullable;

public abstract class ShapeBuilder<N extends Shape, NN extends ShapeBuilder<N, NN>>
extends NodeBuilder<N, NN> {
    private @Nullable ObservableValue<? extends Paint> fill;
    private @Nullable ObservableValue<? extends Paint> stroke;

    protected ShapeBuilder(Supplier<? extends N> factory) {
        assert (factory != null) : "factory is null";
        super(factory);
        this.fill = null;
        this.stroke = null;
    }

    @Override
    public N build() {
        Shape node = (Shape)super.build();
        this.apply(this.fill, node.fillProperty());
        this.apply(this.stroke, node.strokeProperty());
        return (N)node;
    }

    public NN fill(Paint fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = new SimpleObjectProperty((Object)fill);
        return (NN)((ShapeBuilder)this.self());
    }

    public NN fill(Color fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = new SimpleObjectProperty((Object)FxUtil.convert((Color)fill));
        return (NN)((ShapeBuilder)this.self());
    }

    public NN bindFillFx(ObservableValue<Paint> fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = fill;
        return (NN)((ShapeBuilder)this.self());
    }

    public NN bindFill(ObservableValue<Color> fill) {
        if (fill == null) {
            throw new IllegalArgumentException("fill is null");
        }
        this.fill = PropertyConverter.convertReadOnly(fill, (Converter)FxUtil.colorConverter());
        return (NN)((ShapeBuilder)this.self());
    }

    public NN stroke(Paint stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke is null");
        }
        this.stroke = new SimpleObjectProperty((Object)stroke);
        return (NN)((ShapeBuilder)this.self());
    }

    public NN stroke(Color stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke is null");
        }
        this.stroke = new SimpleObjectProperty((Object)FxUtil.convert((Color)stroke));
        return (NN)((ShapeBuilder)this.self());
    }

    public NN bindStrokeFx(ObservableValue<Paint> stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke is null");
        }
        this.stroke = stroke;
        return (NN)((ShapeBuilder)this.self());
    }

    public NN bindStroke(ObservableValue<Color> stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke is null");
        }
        this.stroke = PropertyConverter.convertReadOnly(stroke, (Converter)FxUtil.colorConverter());
        return (NN)((ShapeBuilder)this.self());
    }
}

