/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.data.Color;
import com.dua3.utility.fx.FxFontEmbedded;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.lang.LangUtil;
import com.dua3.utility.lang.Platform;
import com.dua3.utility.math.geometry.Rectangle2f;
import com.dua3.utility.text.FontData;
import com.dua3.utility.text.FontDef;
import com.dua3.utility.text.FontUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class FxFontUtil
implements FontUtil<Font> {
    private static final String DEFAULT_FAMILY;
    private static final float DEFAULT_SIZE;
    private final Map<FontData, Font> fontData2fxFont = new ConcurrentHashMap<FontData, Font>();
    private final Map<Font, FontData> fxFont2FontData = new ConcurrentHashMap<Font, FontData>();
    private final Map<FxFontData, Font> fxFontData2fxFont = new ConcurrentHashMap<FxFontData, Font>();
    private final com.dua3.utility.text.Font defaultFont = this.convert(new Font(DEFAULT_FAMILY, (double)DEFAULT_SIZE));

    public static FxFontUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private FxFontUtil() {
    }

    public Font convert(com.dua3.utility.text.Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        if (font instanceof FxFontEmbedded) {
            FxFontEmbedded fxf = (FxFontEmbedded)font;
            return fxf.fxFont();
        }
        Font fxFont = this.fontData2fxFont.computeIfAbsent(font.getFontData(), fd -> this.getFxFont(fd.family(), fd.size(), fd.bold(), fd.italic()));
        this.fxFont2FontData.putIfAbsent(fxFont, font.getFontData());
        return fxFont;
    }

    public com.dua3.utility.text.Font convert(Font fxFont) {
        if (fxFont == null) {
            throw new IllegalArgumentException("fxFont is null");
        }
        FontData fontData = this.fxFont2FontData.computeIfAbsent(fxFont, FxFontUtil::getFontData);
        this.fontData2fxFont.putIfAbsent(fontData, fxFont);
        return new com.dua3.utility.text.Font(fontData, (Color)Color.BLACK);
    }

    public static FontData getFontData(Font fxFont) {
        if (fxFont == null) {
            throw new IllegalArgumentException("fxFont is null");
        }
        Text text = new Text("Xg|\u2588");
        text.setFont(fxFont);
        Bounds bounds = text.getBoundsInLocal();
        float ascent = (float)text.getBaselineOffset();
        float height = (float)bounds.getHeight();
        float descent = height - ascent;
        text.setText(" ");
        bounds = text.getBoundsInLocal();
        float spaceWidth = (float)bounds.getWidth();
        String style = fxFont.getStyle();
        return FontData.get((String)fxFont.getFamily(), (float)((float)fxFont.getSize()), (boolean)style.contains("bold"), (style.contains("italic") || style.contains("oblique") ? 1 : 0) != 0, (boolean)style.contains("line-under"), (boolean)style.contains("line-through"), (double)ascent, (double)descent, (double)height, (double)spaceWidth);
    }

    public static FontDef getFontDef(Font fxFont) {
        if (fxFont == null) {
            throw new IllegalArgumentException("fxFont is null");
        }
        String style = fxFont.getStyle().toLowerCase(Locale.ROOT);
        FontDef fontDef = new FontDef();
        fontDef.setFamily(fxFont.getFamily());
        fontDef.setSize(Float.valueOf((float)fxFont.getSize()));
        fontDef.setBold(Boolean.valueOf(style.contains("bold")));
        fontDef.setItalic(Boolean.valueOf(style.contains("italic") || style.contains("oblique")));
        fontDef.setUnderline(Boolean.valueOf(style.contains("line-under")));
        fontDef.setStrikeThrough(Boolean.valueOf(style.contains("line-through")));
        return fontDef;
    }

    public Rectangle2f getTextDimension(CharSequence s, com.dua3.utility.text.Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        Bounds bounds = FxUtil.getTextBounds(s, f);
        return Rectangle2f.of((float)((float)bounds.getMinX()), (float)((float)bounds.getMinY()), (float)((float)bounds.getWidth()), (float)((float)bounds.getHeight()));
    }

    public Rectangle2f getTextDimension(CharSequence s, Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        Bounds bounds = FxUtil.getTextBounds(s, f);
        return Rectangle2f.of((float)((float)bounds.getMinX()), (float)((float)bounds.getMinY()), (float)((float)bounds.getWidth()), (float)((float)bounds.getHeight()));
    }

    public double getTextWidth(CharSequence s, com.dua3.utility.text.Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.getTextWidth(s, f);
    }

    public double getTextHeight(CharSequence s, com.dua3.utility.text.Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.getTextHeight(s, f);
    }

    public List<com.dua3.utility.text.Font> loadFonts(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("in is null");
        }
        Font[] fxFonts = Font.loadFonts((InputStream)in, (double)0.0);
        if (fxFonts == null || fxFonts.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<com.dua3.utility.text.Font> fonts = new ArrayList<com.dua3.utility.text.Font>(fxFonts.length);
        for (Font fxFont : fxFonts) {
            fonts.add(this.convert(fxFont));
        }
        return Collections.unmodifiableList(fonts);
    }

    public List<String> getFamilies(FontUtil.FontTypes types) {
        if (types == null) {
            throw new IllegalArgumentException("types is null");
        }
        return switch (types) {
            default -> throw new MatchException(null, null);
            case FontUtil.FontTypes.ALL -> FontList.ALL_FONTS;
            case FontUtil.FontTypes.MONOSPACED -> FontList.MONOSPACE_FONTS;
            case FontUtil.FontTypes.PROPORTIONAL -> FontList.PROPORTIONAL_FONTS;
        };
    }

    private static boolean isMonospaced(String family) {
        assert (family != null) : "family is null";
        Font font = Font.font((String)family, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)14.0);
        Text thin = new Text("1 l");
        Text thick = new Text("M_W");
        thin.setFont(font);
        thick.setFont(font);
        return thin.getLayoutBounds().getWidth() == thick.getLayoutBounds().getWidth();
    }

    public com.dua3.utility.text.Font loadFontAs(InputStream in, com.dua3.utility.text.Font font) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in is null");
        }
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        Font fxFont = Font.loadFont((InputStream)in, (double)font.getSizeInPoints());
        LangUtil.check((fxFont != null ? 1 : 0) != 0, () -> new IOException("no font loaded"));
        return new FxFontEmbedded(fxFont, font.getFamily(), font.getColor(), font.isBold(), font.isItalic(), font.isUnderline(), font.isStrikeThrough());
    }

    public com.dua3.utility.text.Font getDefaultFont() {
        return this.defaultFont;
    }

    public com.dua3.utility.text.Font deriveFont(com.dua3.utility.text.Font font, FontDef fontDef) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        if (fontDef == null) {
            throw new IllegalArgumentException("fontDef is null");
        }
        String family = Objects.requireNonNullElse(fontDef.getFamily(), font.getFamily());
        float size = Objects.requireNonNullElse(fontDef.getSize(), Float.valueOf(font.getSizeInPoints())).floatValue();
        boolean bold = Objects.requireNonNullElse(fontDef.getBold(), font.isBold());
        boolean italic = Objects.requireNonNullElse(fontDef.getItalic(), font.isItalic());
        com.dua3.utility.text.Font baseFont = this.convert(this.getFxFont(family, size, bold, italic));
        FontData fontData = FontData.get((String)family, (float)size, (boolean)bold, (boolean)italic, (boolean)Objects.requireNonNullElse(fontDef.getUnderline(), font.isUnderline()), (boolean)Objects.requireNonNullElse(fontDef.getStrikeThrough(), font.isStrikeThrough()), (double)baseFont.getAscent(), (double)baseFont.getDescent(), (double)baseFont.getHeight(), (double)baseFont.getSpaceWidth());
        Color color = Objects.requireNonNullElse(fontDef.getColor(), font.getColor());
        if (fontData.equals((Object)baseFont.getFontData()) && color.equals((Object)baseFont.getColor())) {
            return baseFont;
        }
        return new com.dua3.utility.text.Font(fontData, color);
    }

    private Font getFxFont(String family, float size, boolean bold, boolean italic) {
        assert (family != null) : "family is null";
        FxFontData fxf = new FxFontData(family, bold ? FontWeight.BOLD : FontWeight.NORMAL, italic ? FontPosture.ITALIC : FontPosture.REGULAR, size);
        return this.fxFontData2fxFont.computeIfAbsent(fxf, k -> Font.font((String)fxf.family, (FontWeight)fxf.weight(), (FontPosture)fxf.posture(), (double)fxf.size()));
    }

    static {
        Font font = Font.getDefault();
        DEFAULT_FAMILY = Platform.isMacOS() ? "Verdana" : font.getFamily();
        DEFAULT_SIZE = (float)font.getSize();
    }

    private static class SingletonHolder {
        private static final FxFontUtil INSTANCE = new FxFontUtil();

        private SingletonHolder() {
        }
    }

    private static class FontList {
        private static final Map<String, Boolean> AVAILABLE_FONTS = Font.getFamilies().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), FxFontUtil::isMonospaced, (a, b) -> b));
        private static final List<String> ALL_FONTS = AVAILABLE_FONTS.keySet().stream().sorted().toList();
        private static final List<String> MONOSPACE_FONTS = ALL_FONTS.stream().filter(AVAILABLE_FONTS::get).toList();
        private static final List<String> PROPORTIONAL_FONTS = ALL_FONTS.stream().filter(Predicate.not(AVAILABLE_FONTS::get)).toList();

        private FontList() {
        }
    }

    private record FxFontData(String family, FontWeight weight, FontPosture posture, double size) {
        private FxFontData {
            if (family == null) {
                throw new NullPointerException("family is null");
            }
            if (weight == null) {
                throw new NullPointerException("weight is null");
            }
            if (posture == null) {
                throw new NullPointerException("posture is null");
            }
        }
    }
}

