/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.data.Image;
import com.dua3.utility.fx.FxFontUtil;
import com.dua3.utility.fx.FxImageUtil;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.math.geometry.AffineTransformation2f;
import com.dua3.utility.math.geometry.Arc2f;
import com.dua3.utility.math.geometry.ClosePath2f;
import com.dua3.utility.math.geometry.Curve2f;
import com.dua3.utility.math.geometry.Line2f;
import com.dua3.utility.math.geometry.MoveTo2f;
import com.dua3.utility.math.geometry.Path2f;
import com.dua3.utility.math.geometry.Rectangle2f;
import com.dua3.utility.math.geometry.Segment2f;
import com.dua3.utility.math.geometry.Vector2f;
import com.dua3.utility.text.FontUtil;
import com.dua3.utility.ui.Graphics;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class FxGraphics
implements Graphics {
    private static final FxFontUtil FONT_UTIL = FxFontUtil.getInstance();
    private static final FxImageUtil IMAGE_UTIL = FxImageUtil.getInstance();
    private static final com.dua3.utility.text.Font DEFAULT_FONT = FONT_UTIL.getDefaultFont();
    private static final Font DEFAULT_FONT_FX = FONT_UTIL.convert(DEFAULT_FONT);
    private final GraphicsContext gc;
    private final AffineTransformation2f parentTransform;
    private final float scale;
    private float width;
    private float height;
    private boolean isDrawing;
    private State state;

    private void applyCurrentState() {
        this.gc.setTransform(FxUtil.convert(this.state.transform.append(this.parentTransform)));
        this.gc.setFill((Paint)this.state.fxFillColor);
        this.gc.setStroke(this.state.fxStrokeColor);
        this.gc.setLineWidth((double)this.state.strokeWidth);
    }

    public FxGraphics(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this(canvas.getGraphicsContext2D(), (float)canvas.getWidth(), (float)canvas.getHeight());
    }

    public FxGraphics(GraphicsContext gc, float width, float height) {
        if (gc == null) {
            throw new IllegalArgumentException("gc is null");
        }
        this.isDrawing = true;
        this.state = new State();
        this.gc = gc;
        this.width = width;
        this.height = height;
        this.scale = 1.0f;
        this.parentTransform = FxUtil.convert(gc.getTransform());
        gc.save();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public FontUtil<?> getFontUtil() {
        assert (this.isDrawing) : "instance has already been closed!";
        return FONT_UTIL;
    }

    public com.dua3.utility.text.Font getDefaultFont() {
        return DEFAULT_FONT;
    }

    public void reset() {
        this.width = (float)this.gc.getCanvas().getWidth();
        this.height = (float)this.gc.getCanvas().getHeight();
        this.gc.clearRect(0.0, 0.0, (double)this.width, (double)this.height);
        this.isDrawing = true;
    }

    public void close() {
        assert (this.isDrawing) : "instance has already been closed!";
        this.isDrawing = false;
    }

    public void strokeRect(float x, float y, float w, float h) {
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.setStroke(this.state.fxStrokeColor);
        this.gc.setLineWidth((double)this.state.strokeWidth);
        this.gc.strokeRect((double)x, (double)y, (double)w, (double)h);
    }

    public void fillRect(float x, float y, float w, float h) {
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.setFill((Paint)this.state.fxFillColor);
        this.gc.fillRect((double)x, (double)y, (double)w, (double)h);
    }

    public void strokeEllipse(float x, float y, float rx, float ry, float angle) {
        assert (this.isDrawing) : "instance has already been closed!";
        Vector2f p0 = Vector2f.of((float)(x + rx), (float)y);
        Vector2f p1 = Vector2f.of((float)(x - rx), (float)y);
        Vector2f r = Vector2f.of((float)rx, (float)ry);
        this.gc.setStroke(this.state.fxStrokeColor);
        this.strokePath(Path2f.builder().moveTo(p0).arcTo(p1, r, angle, false, true).arcTo(p0, r, angle, false, true).build());
    }

    public void fillEllipse(float x, float y, float rx, float ry, float angle) {
        assert (this.isDrawing) : "instance has already been closed!";
        Vector2f p0 = Vector2f.of((float)(x + rx), (float)y);
        Vector2f p1 = Vector2f.of((float)(x - rx), (float)y);
        Vector2f r = Vector2f.of((float)rx, (float)ry);
        this.gc.setFill((Paint)this.state.fxFillColor);
        this.fillPath(Path2f.builder().moveTo(p0).arcTo(p1, r, angle, false, true).arcTo(p0, r, angle, false, true).build());
    }

    public void strokeLine(float x1, float y1, float x2, float y2) {
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.setStroke(this.state.fxStrokeColor);
        this.gc.setLineWidth((double)this.state.strokeWidth);
        this.gc.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void strokePath(Path2f path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.beginPath();
        this.path(path);
        this.gc.stroke();
    }

    public void fillPath(Path2f path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.beginPath();
        this.path(path);
        this.gc.fill();
    }

    public void drawImage(Image image, float x, float y) {
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.drawImage(IMAGE_UTIL.convert(image), (double)x, (double)y);
    }

    public void clip(Path2f path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.gc.beginPath();
        this.path(path);
        this.gc.clip();
    }

    public void clip(Rectangle2f r) {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        this.gc.beginPath();
        this.gc.rect((double)r.x(), (double)r.y(), (double)r.width(), (double)r.height());
        this.gc.clip();
    }

    public void resetClip() {
        this.gc.restore();
        this.gc.save();
        this.applyCurrentState();
    }

    private void path(Path2f path) {
        assert (path != null) : "path is null";
        path.segments().forEach(segment -> {
            Segment2f segment2f = segment;
            Objects.requireNonNull(segment2f);
            Segment2f selector0$temp = segment2f;
            int index$1 = 0;
            block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MoveTo2f.class, Line2f.class, Curve2f.class, Arc2f.class, ClosePath2f.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    MoveTo2f s = (MoveTo2f)selector0$temp;
                    this.gc.moveTo((double)s.end().x(), (double)s.end().y());
                    break;
                }
                case 1: {
                    Line2f s = (Line2f)selector0$temp;
                    this.gc.lineTo((double)s.end().x(), (double)s.end().y());
                    break;
                }
                case 2: {
                    Curve2f s = (Curve2f)selector0$temp;
                    switch (s.numberOfControls()) {
                        case 3: {
                            this.gc.quadraticCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y());
                            break block0;
                        }
                        case 4: {
                            this.gc.bezierCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y(), (double)s.control(3).x(), (double)s.control(3).y());
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported number of control points: " + s.numberOfControls());
                }
                case 3: {
                    Arc2f s = (Arc2f)selector0$temp;
                    Graphics.approximateArc((Arc2f)s, this::moveTo, this::generateBezierSegment);
                    break;
                }
                case 4: {
                    ClosePath2f s = (ClosePath2f)selector0$temp;
                    this.gc.closePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported segment type: " + segment.getClass().getName());
                }
            }
        });
    }

    private void moveTo(Vector2f p) {
        assert (p != null) : "p is null";
        this.gc.moveTo((double)p.x(), (double)p.y());
    }

    private void generateBezierSegment(Vector2f[] points) {
        assert (points != null) : "points is null";
        this.gc.bezierCurveTo((double)points[0].x(), (double)points[0].y(), (double)points[1].x(), (double)points[1].y(), (double)points[2].x(), (double)points[2].y());
    }

    public void setStroke(com.dua3.utility.data.Color c, float width) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.strokeColor = c;
        this.state.fxStrokeColor = FxUtil.convert(this.state.strokeColor);
        this.state.strokeWidth = width;
        this.gc.setStroke(this.state.fxStrokeColor);
        this.gc.setLineWidth((double)this.state.strokeWidth);
    }

    public void setStrokeColor(com.dua3.utility.data.Color c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.strokeColor = c;
        this.state.fxStrokeColor = FxUtil.convert(this.state.strokeColor);
        this.gc.setStroke(this.state.fxStrokeColor);
    }

    public void setStrokeWidth(float width) {
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.strokeWidth = width;
        this.gc.setLineWidth((double)this.state.strokeWidth);
    }

    public com.dua3.utility.data.Color getStrokeColor() {
        return this.state.strokeColor;
    }

    public float getStrokeWidth() {
        return this.state.strokeWidth;
    }

    public void setFill(com.dua3.utility.data.Color c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.fillColor = c;
        this.state.fxFillColor = FxUtil.convert(this.state.fillColor);
        this.gc.setFill((Paint)this.state.fxFillColor);
    }

    public com.dua3.utility.data.Color getFill() {
        return this.state.fillColor;
    }

    public void setTransformation(AffineTransformation2f t) {
        if (t == null) {
            throw new IllegalArgumentException("t is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.transform = t;
        this.gc.setTransform(FxUtil.convert(t.append(this.parentTransform)));
    }

    public AffineTransformation2f getTransformation() {
        assert (this.isDrawing) : "instance has already been closed!";
        return this.state.transform;
    }

    public void setFont(com.dua3.utility.text.Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.state.fxTextColor = FxUtil.convert(font.getColor());
        this.state.font = font;
        this.state.fxFont = FONT_UTIL.convert(this.state.font.scaled(this.scale));
        this.state.isStrikeThrough = font.isStrikeThrough();
        this.state.isUnderline = font.isUnderline();
    }

    public com.dua3.utility.text.Font getFont() {
        return this.state.font;
    }

    public void drawText(CharSequence text, float x, float y) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        assert (this.isDrawing) : "instance has already been closed!";
        this.gc.setFont(this.state.fxFont);
        this.gc.setFill((Paint)this.state.fxTextColor);
        this.gc.fillText(text.toString(), (double)x, (double)y);
        if (this.state.isStrikeThrough || this.state.isUnderline) {
            double yStroke;
            double strokeWidth = this.state.fxFont.getSize() / 15.0;
            Text t = new Text(text.toString());
            t.setFont(this.state.fxFont);
            Bounds r = t.getBoundsInLocal();
            double wStroke = r.getWidth();
            this.gc.setStroke((Paint)this.state.fxTextColor);
            this.gc.setLineWidth(strokeWidth);
            if (this.state.isUnderline) {
                yStroke = (double)y + r.getMaxY() / 2.0;
                this.gc.strokeLine((double)x, yStroke, (double)x + wStroke, yStroke);
            }
            if (this.state.isStrikeThrough) {
                yStroke = (double)y + r.getMinY() / 2.0 + r.getMaxY();
                this.gc.strokeLine((double)x, yStroke, (double)x + wStroke, yStroke);
            }
        }
    }

    private static final class State
    implements Cloneable {
        AffineTransformation2f transform = AffineTransformation2f.identity();
        com.dua3.utility.text.Font font = DEFAULT_FONT;
        Font fxFont = DEFAULT_FONT_FX;
        Color fxTextColor = FxUtil.convert(this.font.getColor());
        boolean isStrikeThrough = false;
        boolean isUnderline = false;
        com.dua3.utility.data.Color strokeColor = com.dua3.utility.data.Color.BLACK;
        Paint fxStrokeColor = Color.BLACK;
        float strokeWidth = 1.0f;
        com.dua3.utility.data.Color fillColor = com.dua3.utility.data.Color.BLACK;
        Color fxFillColor = Color.BLACK;

        private State() {
        }

        public State clone() throws CloneNotSupportedException {
            return (State)super.clone();
        }
    }
}

