/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.data.Image;
import com.dua3.utility.data.ImageUtil;
import com.dua3.utility.fx.FxImage;
import java.io.InputStream;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public final class FxImageUtil
implements ImageUtil<javafx.scene.image.Image> {
    private FxImageUtil() {
    }

    public static FxImageUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public FxImage load(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        return new FxImage(new javafx.scene.image.Image(inputStream));
    }

    public FxImage create(int w, int h, int[] argb) {
        if (argb == null) {
            throw new IllegalArgumentException("argb is null");
        }
        WritableImage wr = new WritableImage(w, h);
        PixelWriter pw = wr.getPixelWriter();
        pw.setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), argb, 0, w);
        return new FxImage((javafx.scene.image.Image)wr);
    }

    public javafx.scene.image.Image convert(Image img) {
        if (img == null) {
            throw new IllegalArgumentException("img is null");
        }
        if (!(img instanceof FxImage)) {
            throw new UnsupportedOperationException("unsupported image class: " + String.valueOf(img.getClass()));
        }
        return ((FxImage)img).fxImage();
    }

    public FxImage convert(javafx.scene.image.Image img) {
        if (img == null) {
            throw new IllegalArgumentException("img is null");
        }
        return new FxImage(img);
    }

    private static class SingletonHolder {
        private static final FxImageUtil INSTANCE = new FxImageUtil();

        private SingletonHolder() {
        }
    }
}

