/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.data.Color;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.LogEntriesObservableList;
import com.dua3.utility.logging.DefaultLogEntryFilter;
import com.dua3.utility.logging.LogBuffer;
import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryHandler;
import com.dua3.utility.logging.LogLevel;
import com.dua3.utility.logging.LogUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.jspecify.annotations.Nullable;

public class FxLogPane
extends BorderPane {
    private static final double COLUMN_WIDTH_MAX = Double.MAX_VALUE;
    private static final double COLUMN_WIDTH_LARGE = 10000.0;
    private final LogBuffer logBuffer;
    private final Function<? super LogEntry, ? extends Color> colorize;
    private final TextArea details;
    private final TableView<@Nullable LogEntry> tableView;
    private volatile @Nullable LogEntry selectedItem;
    private boolean autoScroll;

    private <T> TableColumn<LogEntry, T> createColumn(String name, Function<? super LogEntry, ? extends T> getter, boolean fixedWidth, String ... sampleTexts) {
        if (!$assertionsDisabled) {
            if (name == null) {
                throw new AssertionError((Object)"name is null");
            }
            if (getter == null) {
                throw new AssertionError((Object)"getter is null");
            }
            if (sampleTexts == null) {
                throw new AssertionError((Object)"sampleTexts is null");
            }
        }
        TableColumn column = new TableColumn(name);
        column.setCellValueFactory(entry -> new SimpleObjectProperty(getter.apply((LogEntry)entry.getValue())));
        if (sampleTexts.length == 0) {
            column.setPrefWidth(10000.0);
            column.setMaxWidth(Double.MAX_VALUE);
        } else {
            double w = 8.0 + Stream.of(sampleTexts).mapToDouble(FxLogPane::getDisplayWidth).max().orElse(200.0);
            column.setPrefWidth(w);
            if (fixedWidth) {
                column.setMinWidth(w);
                column.setMaxWidth(w);
            } else {
                column.setMaxWidth(Double.MAX_VALUE);
            }
        }
        column.setCellFactory(col -> new TableCell<LogEntry, T>(){

            protected void updateItem(@Nullable T item, boolean empty) {
                super.updateItem(item, empty);
                TableRow row = this.getTableRow();
                if (empty || row == null || row.getItem() == null) {
                    this.setText(null);
                    this.setStyle(null);
                } else {
                    this.setText(item == null ? "" : item.toString());
                    Color textColor = FxLogPane.this.colorize.apply((LogEntry)row.getItem());
                    this.setTextFill((Paint)FxUtil.convert(textColor));
                }
                super.updateItem(item, empty);
            }
        });
        return column;
    }

    private static double getDisplayWidth(String s) {
        assert (s != null) : "s is null";
        return new Text(s).getLayoutBounds().getWidth();
    }

    public FxLogPane() {
        this(10000);
    }

    public FxLogPane(int bufferSize) {
        this(FxLogPane.createBuffer(bufferSize));
    }

    public FxLogPane(LogBuffer logBuffer) {
        if (logBuffer == null) {
            throw new IllegalArgumentException("logBuffer is null");
        }
        this(logBuffer, FxLogPane::defaultColorize);
    }

    public FxLogPane(LogBuffer logBuffer, Function<? super LogEntry, Color> colorize) {
        if (logBuffer == null) {
            throw new IllegalArgumentException("logBuffer is null");
        }
        if (colorize == null) {
            throw new IllegalArgumentException("colorize is null");
        }
        this.autoScroll = true;
        FilteredList entries = new FilteredList((ObservableList)new LogEntriesObservableList(logBuffer), p -> true);
        this.logBuffer = logBuffer;
        this.colorize = colorize;
        ToolBar toolBar = new ToolBar();
        this.tableView = new TableView((ObservableList)entries);
        this.details = new TextArea();
        entries.addListener(this::onEntries);
        double tfWidth = FxLogPane.getDisplayWidth("X".repeat(32));
        ComboBox cbLogLevel = new ComboBox(FXCollections.observableArrayList((Object[])LogLevel.values()));
        TextField tfLoggerName = new TextField();
        tfLoggerName.setPrefWidth(tfWidth);
        TextField tfMessageContent = new TextField();
        tfMessageContent.setPrefWidth(tfWidth);
        Runnable updateFilter = () -> {
            LogLevel level = (LogLevel)cbLogLevel.getSelectionModel().getSelectedItem();
            String loggerText = tfLoggerName.getText().toLowerCase(Locale.ROOT).strip();
            BiPredicate<String, LogLevel> predicateLoggerName = loggerText.isEmpty() ? (name, lvl) -> true : (name, lvl) -> name.toLowerCase(Locale.ROOT).contains(loggerText);
            String messageContent = tfMessageContent.getText();
            BiPredicate<String, LogLevel> predicateContent = messageContent.isEmpty() ? (text, lvl) -> true : (text, lvl) -> text.contains(messageContent);
            entries.setPredicate((Predicate)new DefaultLogEntryFilter(level, predicateLoggerName, predicateContent));
        };
        cbLogLevel.valueProperty().addListener((v, o, n) -> updateFilter.run());
        tfLoggerName.textProperty().addListener((v, o, n) -> updateFilter.run());
        tfMessageContent.textProperty().addListener((v, o, n) -> updateFilter.run());
        cbLogLevel.setValue((Object)LogLevel.INFO);
        tfLoggerName.clear();
        tfMessageContent.clear();
        TextField tfSearchText = new TextField();
        tfSearchText.setPrefWidth(tfWidth);
        Button btnSearchUp = new Button("\u25b2");
        Button btnSearchDown = new Button("\u25bc");
        BiConsumer<String, Boolean> searchAction = (text, up) -> {
            String lowercaseText = text.toLowerCase(Locale.ROOT);
            int step = up != false ? -1 : 1;
            LogEntry current = this.selectedItem;
            List items = List.copyOf(entries);
            int n = items.size();
            int pos = current != null ? Math.max(0, items.indexOf(current)) : 0;
            for (int i = 0; i < n; ++i) {
                int j = Math.floorMod(pos + step * i, n);
                LogEntry logEntry = (LogEntry)items.get(j);
                if (!logEntry.message().toLowerCase(Locale.ROOT).contains(lowercaseText) || i == 0 && current != null) continue;
                this.selectLogEntry(logEntry);
                break;
            }
        };
        tfSearchText.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (event.isShiftDown()) {
                    searchAction.accept(tfSearchText.getText(), true);
                } else {
                    searchAction.accept(tfSearchText.getText(), false);
                }
            }
        });
        btnSearchUp.setOnAction(evt -> searchAction.accept(tfSearchText.getText(), true));
        btnSearchDown.setOnAction(evt -> searchAction.accept(tfSearchText.getText(), false));
        Button btnClear = new Button("\ud83d\uddd1\ufe0f");
        btnClear.setOnAction(evt -> logBuffer.clear());
        toolBar.getItems().setAll((Object[])new Node[]{new Label("Level:"), cbLogLevel, new Label("Logger:"), tfLoggerName, new Label("Text:"), tfMessageContent, new Separator(Orientation.HORIZONTAL), new Label("Search:"), tfSearchText, btnSearchUp, btnSearchDown, new Separator(Orientation.HORIZONTAL), btnClear});
        this.tableView.setEditable(false);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().setAll((Object[])new TableColumn[]{this.createColumn("Time", LogEntry::time, true, "8888-88-88T88:88:88.8888888"), this.createColumn("Level", LogEntry::level, true, (String[])Arrays.stream(LogLevel.values()).map(Object::toString).toArray(String[]::new)), this.createColumn("Logger", LogEntry::loggerName, false, "X".repeat(20)), this.createColumn("Message", LogEntry::message, false, "X".repeat(60))});
        this.tableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection == null) {
                this.details.clear();
                this.autoScroll = this.autoScroll || this.isScrolledToBottom();
            } else {
                this.selectedItem = newSelection;
                this.autoScroll = false;
                this.details.setText(newSelection.toString());
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.clearSelection();
                this.autoScroll = true;
                event.consume();
            }
        });
        this.tableView.addEventFilter(ScrollEvent.ANY, this::onScrollEvent);
        SplitPane splitPane = new SplitPane(new Node[]{this.tableView, this.details});
        splitPane.setOrientation(Orientation.VERTICAL);
        this.setTop((Node)toolBar);
        this.setCenter((Node)splitPane);
    }

    private void selectLogEntry(LogEntry logEntry) {
        assert (logEntry != null) : "logEntry is null";
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        this.tableView.getSelectionModel().select((Object)logEntry);
        this.tableView.scrollTo((Object)logEntry);
    }

    private void onScrollEvent(ScrollEvent evt) {
        assert (evt != null) : "evt is null";
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        this.autoScroll = this.autoScroll ? false : this.isSelectionEmpty() && this.isScrolledToBottom();
    }

    private Optional<ScrollBar> getScrollBar(Orientation orientation) {
        assert (orientation != null) : "orientation is null";
        for (Node node : this.tableView.lookupAll(".scroll-bar")) {
            ScrollBar sb;
            if (!(node instanceof ScrollBar) || (sb = (ScrollBar)node).getOrientation() != orientation) continue;
            return Optional.of(sb);
        }
        return Optional.empty();
    }

    private boolean isSelectionEmpty() {
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        return this.selectedItem == null;
    }

    private void clearSelection() {
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        this.tableView.getSelectionModel().clearSelection();
        this.selectedItem = null;
    }

    private void onEntries(ListChangeListener.Change<? extends LogEntry> change) {
        assert (change != null) : "change is null";
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        if (this.autoScroll) {
            Platform.runLater(() -> {
                this.tableView.scrollTo(this.tableView.getItems().size() - 1);
                this.autoScroll = true;
            });
        }
        if (!this.isSelectionEmpty()) {
            Platform.runLater(() -> this.tableView.getSelectionModel().select((Object)this.selectedItem));
        }
    }

    private boolean isScrolledToBottom() {
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        return this.getScrollBar(Orientation.VERTICAL).map(sb -> {
            double step;
            double max = sb.getMax();
            double current = sb.getValue();
            return current >= max - (step = max / (1.0 + (double)this.tableView.getItems().size()));
        }).orElse(true);
    }

    private static LogBuffer createBuffer(int bufferSize) {
        LogBuffer buffer = new LogBuffer(bufferSize);
        LogUtil.getGlobalDispatcher().addLogEntryHandler((LogEntryHandler)buffer);
        return buffer;
    }

    private static Color defaultColorize(LogEntry entry) {
        assert (entry != null) : "entry is null";
        return switch (entry.level()) {
            default -> throw new MatchException(null, null);
            case LogLevel.ERROR -> Color.DARKRED;
            case LogLevel.WARN -> Color.RED;
            case LogLevel.INFO -> Color.DARKBLUE;
            case LogLevel.DEBUG -> Color.BLACK;
            case LogLevel.TRACE -> Color.DARKGRAY;
        };
    }

    public LogBuffer getLogBuffer() {
        return this.logBuffer;
    }
}

