/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.fx.FxLogPane;
import com.dua3.utility.logging.LogBuffer;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class FxLogWindow
extends Stage {
    private static final String DEFAULT_WINDOW_TITLE = "Log";
    private final LogBuffer logBuffer;

    public FxLogWindow() {
        this(DEFAULT_WINDOW_TITLE);
    }

    public FxLogWindow(String title) {
        if (title == null) {
            throw new IllegalArgumentException("title is null");
        }
        this(title, new LogBuffer());
    }

    public FxLogWindow(int maxLines) {
        this(DEFAULT_WINDOW_TITLE, maxLines);
    }

    public FxLogWindow(String title, int maxLines) {
        if (title == null) {
            throw new IllegalArgumentException("title is null");
        }
        this(title, new LogBuffer(maxLines));
    }

    public FxLogWindow(LogBuffer logBuffer) {
        if (logBuffer == null) {
            throw new IllegalArgumentException("logBuffer is null");
        }
        this(DEFAULT_WINDOW_TITLE, logBuffer);
    }

    public FxLogWindow(String title, LogBuffer logBuffer) {
        if (title == null) {
            throw new IllegalArgumentException("title is null");
        }
        if (logBuffer == null) {
            throw new IllegalArgumentException("logBuffer is null");
        }
        this.logBuffer = logBuffer;
        FxLogPane logPane = new FxLogPane(this.logBuffer);
        Scene scene = new Scene((Parent)logPane, 800.0, 400.0);
        this.setScene(scene);
        this.setTitle(title);
    }

    public LogBuffer getLogBuffer() {
        return this.logBuffer;
    }
}

