/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.scene.Node;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public final class FxRefresh {
    private static final Logger LOG = LogManager.getLogger(FxRefresh.class);
    private final String name;
    private final AtomicLong currentRevision;
    private final AtomicLong requestedRevision;
    private final ReentrantLock lock;
    private final Condition trigger;
    private final AtomicBoolean active;
    private final Runnable task;
    private volatile @Nullable Thread updateThread;

    private FxRefresh(String name, Runnable task) {
        if (!$assertionsDisabled) {
            if (name == null) {
                throw new AssertionError((Object)"name is null");
            }
            if (task == null) {
                throw new AssertionError((Object)"task is null");
            }
        }
        this.currentRevision = new AtomicLong();
        this.requestedRevision = new AtomicLong();
        this.lock = new ReentrantLock();
        this.trigger = this.lock.newCondition();
        this.active = new AtomicBoolean(false);
        this.name = name;
        this.task = task;
        Thread thread = new Thread(this::refreshLoop);
        thread.setDaemon(true);
        this.updateThread = thread;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLoop() {
        LOG.debug("[{}] entering refresh loop", (Object)this.name);
        do {
            this.lock.lock();
            try {
                while (!(this.updateThread == null || this.active.get() && this.requestedRevision.get() > this.currentRevision.get())) {
                    this.trigger.await();
                }
            }
            catch (InterruptedException e) {
                LOG.debug("[{}] interrupted, shutting down", (Object)this.name);
                Thread.currentThread().interrupt();
                this.stop();
            }
            finally {
                this.lock.unlock();
            }
            if (!this.active.get()) continue;
            long myRevision = this.requestedRevision.get();
            if (myRevision != this.currentRevision.getAndSet(myRevision)) {
                try {
                    LOG.debug("[{}] starting refresh with revision: {}", (Object)this.name, (Object)myRevision);
                    this.task.run();
                    LOG.debug("[{}] refreshed to revision: {}", (Object)this.name, (Object)myRevision);
                }
                catch (Exception e) {
                    LOG.warn("task aborted, exception swallowed, current revision {} might have inconsistent state", (Object)myRevision, (Object)e);
                }
                finally {
                    this.currentRevision.set(myRevision);
                }
            } else {
                LOG.debug("[{}] already at revision: {}", (Object)this.name, (Object)myRevision);
            }
        } while (this.updateThread != null);
        LOG.debug("[{}] exiting refresh loop", (Object)this.name);
    }

    public synchronized void stop() {
        LOG.debug("[{}] stopping", (Object)this.name);
        this.updateThread = null;
        this.setActive(false);
    }

    public static FxRefresh create(String name, Runnable task) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        return FxRefresh.create(name, task, true);
    }

    public static FxRefresh create(String name, Runnable task, boolean active) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        FxRefresh r = new FxRefresh(name, task);
        r.setActive(active);
        return r;
    }

    private void signal() {
        LOG.debug("[{}] raise signal", (Object)this.name);
        this.lock.lock();
        try {
            this.trigger.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static FxRefresh create(String name, Runnable task, Node node) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return FxRefresh.create(name, task, node, true);
    }

    public static FxRefresh create(String name, Runnable task, Node node, boolean active) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        FxRefresh r = new FxRefresh(name, () -> {
            if (!node.isVisible()) {
                LOG.debug("node is not visible, update skipped");
                return;
            }
            task.run();
        });
        node.parentProperty().addListener((v, o, n) -> {
            if (n == null) {
                LOG.debug("node was removed from parent, stopping refresher");
                r.stop();
            }
        });
        node.sceneProperty().addListener((v, o, n) -> {
            if (n == null) {
                LOG.debug("node was removed from scene graph, stopping refresher");
                r.stop();
            }
        });
        r.setActive(active);
        return r;
    }

    public boolean isRunning() {
        return this.updateThread != null;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public synchronized void setActive(boolean flag) {
        LOG.debug("[{}] setActive({})", (Object)this.name, (Object)flag);
        this.active.set(flag);
        this.signal();
    }

    public void refresh() {
        LOG.debug("[{}] refresh requested", (Object)this.name);
        this.lock.lock();
        try {
            long revision = this.requestedRevision.incrementAndGet();
            LOG.debug("[{}] requested revision {}", (Object)this.name, (Object)revision);
            this.trigger.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

