/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.fx.FxTaskTracker;
import java.util.ArrayList;
import java.util.List;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public abstract class FxService<T>
extends Service<T> {
    private final List<FxTaskTracker> taskTrackers = new ArrayList<FxTaskTracker>();

    protected FxService() {
    }

    protected final Task<T> createTask() {
        Task<T> task = this.doCreateTask();
        task.progressProperty().addListener((v, o, n) -> this.updateTaskProgress(task, n.doubleValue()));
        task.stateProperty().addListener((v, o, n) -> this.updateTaskState(task, (Worker.State)n));
        task.titleProperty().addListener((v, o, n) -> this.updateTaskTitle(task, (String)n));
        return task;
    }

    protected abstract Task<T> doCreateTask();

    private void updateTaskProgress(Task<T> task, double arg) {
        assert (task != null) : "task is null";
        this.taskTrackers.forEach(t -> t.updateTaskProgress(task, arg));
    }

    private void updateTaskState(Task<T> task, Worker.State arg) {
        if (!$assertionsDisabled) {
            if (task == null) {
                throw new AssertionError((Object)"task is null");
            }
            if (arg == null) {
                throw new AssertionError((Object)"arg is null");
            }
        }
        this.taskTrackers.forEach(t -> t.updateTaskState(task, arg));
    }

    private void updateTaskTitle(Task<T> task, String arg) {
        if (!$assertionsDisabled) {
            if (task == null) {
                throw new AssertionError((Object)"task is null");
            }
            if (arg == null) {
                throw new AssertionError((Object)"arg is null");
            }
        }
        this.taskTrackers.forEach(t -> t.updateTaskTitle(task, arg));
    }

    public void addTaskTracker(FxTaskTracker t) {
        if (t == null) {
            throw new IllegalArgumentException("t is null");
        }
        this.taskTrackers.add(t);
    }

    public void removeTaskTracker(FxTaskTracker t) {
        if (t == null) {
            throw new IllegalArgumentException("t is null");
        }
        this.taskTrackers.remove(t);
    }
}

