/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.concurrent.Value;
import com.dua3.utility.data.Color;
import com.dua3.utility.data.Converter;
import com.dua3.utility.data.DataUtil;
import com.dua3.utility.data.Image;
import com.dua3.utility.fx.FxFontUtil;
import com.dua3.utility.fx.FxImageUtil;
import com.dua3.utility.io.IoUtil;
import com.dua3.utility.math.geometry.AffineTransformation2f;
import com.dua3.utility.math.geometry.Arc2f;
import com.dua3.utility.math.geometry.ClosePath2f;
import com.dua3.utility.math.geometry.Curve2f;
import com.dua3.utility.math.geometry.Line2f;
import com.dua3.utility.math.geometry.MoveTo2f;
import com.dua3.utility.math.geometry.Path2f;
import com.dua3.utility.math.geometry.Rectangle2f;
import com.dua3.utility.math.geometry.Scale2f;
import com.dua3.utility.math.geometry.Segment2f;
import com.dua3.utility.text.Font;
import com.dua3.utility.text.HtmlConversionOption;
import com.dua3.utility.text.HtmlConverter;
import com.dua3.utility.text.RichText;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.jspecify.annotations.Nullable;

public final class FxUtil {
    private static final Pattern PATTERN_FILENAME_AND_DOT = Pattern.compile("^\\*\\.");
    private static final FxFontUtil FX_FONT_UTIL = FxFontUtil.getInstance();
    public static final ObservableBooleanValue TRUE = new SimpleBooleanProperty(true);
    public static final ObservableBooleanValue FALSE = new SimpleBooleanProperty(false);

    private FxUtil() {
    }

    public static javafx.scene.paint.Color convert(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        int argb = color.argb();
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return javafx.scene.paint.Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
    }

    public static Color convert(javafx.scene.paint.Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        return Color.rgba((int)((int)Math.round(color.getRed() * 255.0)), (int)((int)Math.round(color.getGreen() * 255.0)), (int)((int)Math.round(color.getBlue() * 255.0)), (int)((int)Math.round(color.getOpacity() * 255.0)));
    }

    public static FillRule convert(com.dua3.utility.math.geometry.FillRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        return rule == com.dua3.utility.math.geometry.FillRule.EVEN_ODD ? FillRule.EVEN_ODD : FillRule.NON_ZERO;
    }

    public static com.dua3.utility.math.geometry.FillRule convert(FillRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        return rule == FillRule.EVEN_ODD ? com.dua3.utility.math.geometry.FillRule.EVEN_ODD : com.dua3.utility.math.geometry.FillRule.NON_ZERO;
    }

    public static Affine convert(AffineTransformation2f at) {
        if (at == null) {
            throw new IllegalArgumentException("at is null");
        }
        return new Affine((double)at.getScaleX(), (double)at.getShearX(), (double)at.getTranslateX(), (double)at.getShearY(), (double)at.getScaleY(), (double)at.getTranslateY());
    }

    public static AffineTransformation2f convert(Affine a) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        return new AffineTransformation2f((float)a.getMxx(), (float)a.getMyx(), (float)a.getTx(), (float)a.getMyx(), (float)a.getMyy(), (float)a.getTy());
    }

    public static javafx.scene.shape.Path convert(Path2f path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        javafx.scene.shape.Path jfxPath = new javafx.scene.shape.Path();
        path.segments().forEach(segment -> {
            Segment2f segment2f = segment;
            Objects.requireNonNull(segment2f);
            Segment2f selector0$temp = segment2f;
            int index$1 = 0;
            block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MoveTo2f.class, Line2f.class, Curve2f.class, Arc2f.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    MoveTo2f s = (MoveTo2f)selector0$temp;
                    jfxPath.getElements().add((Object)new MoveTo((double)s.end().x(), (double)s.end().y()));
                    break;
                }
                case 1: {
                    Line2f s = (Line2f)selector0$temp;
                    jfxPath.getElements().add((Object)new LineTo((double)s.end().x(), (double)s.end().y()));
                    break;
                }
                case 2: {
                    Curve2f s = (Curve2f)selector0$temp;
                    switch (s.numberOfControls()) {
                        case 3: {
                            jfxPath.getElements().add((Object)new QuadCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y()));
                            break block0;
                        }
                        case 4: {
                            jfxPath.getElements().add((Object)new CubicCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y(), (double)s.control(3).x(), (double)s.control(3).y()));
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported number of control points: " + s.numberOfControls());
                }
                case 3: {
                    Arc2f s = (Arc2f)selector0$temp;
                    jfxPath.getElements().add((Object)new ArcTo((double)s.rx(), (double)s.ry(), (double)s.angle(), (double)s.control(1).x(), (double)s.control(1).y(), false, false));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported segment type: " + segment.getClass().getName());
                }
            }
        });
        return jfxPath;
    }

    public static Rectangle convert(Rectangle2f r) {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        return new Rectangle((double)r.x(), (double)r.y(), (double)r.width(), (double)r.height());
    }

    public static Rectangle2f convert(Rectangle2D r) {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        return new Rectangle2f((float)r.getMinX(), (float)r.getMinY(), (float)r.getWidth(), (float)r.getHeight());
    }

    public static Rectangle2f convert(Bounds b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return new Rectangle2f((float)b.getMinX(), (float)b.getMinY(), (float)b.getWidth(), (float)b.getHeight());
    }

    public static Bounds getTextBounds(CharSequence s, Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.boundsInLocal(s, f);
    }

    public static Bounds getTextBounds(CharSequence s, javafx.scene.text.Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.boundsInLocal(s, f);
    }

    private static Bounds boundsInLocal(CharSequence s, Font f) {
        if (!$assertionsDisabled) {
            if (s == null) {
                throw new AssertionError((Object)"s is null");
            }
            if (f == null) {
                throw new AssertionError((Object)"f is null");
            }
        }
        Text text = new Text(s.toString());
        text.setFont(FxUtil.convert(f));
        return text.getBoundsInLocal();
    }

    private static Bounds boundsInLocal(CharSequence s, javafx.scene.text.Font f) {
        if (!$assertionsDisabled) {
            if (s == null) {
                throw new AssertionError((Object)"s is null");
            }
            if (f == null) {
                throw new AssertionError((Object)"f is null");
            }
        }
        Text text = new Text(s.toString());
        text.setFont(f);
        return text.getBoundsInLocal();
    }

    public static javafx.scene.text.Font convert(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null");
        }
        return FX_FONT_UTIL.convert(font);
    }

    public static Font convert(javafx.scene.text.Font fxFont) {
        if (fxFont == null) {
            throw new IllegalArgumentException("fxFont is null");
        }
        return FX_FONT_UTIL.convert(fxFont);
    }

    public static double getTextWidth(CharSequence s, Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.boundsInLocal(s, f).getWidth();
    }

    public static double getTextHeight(CharSequence s, Font f) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return FxUtil.boundsInLocal(s, f).getHeight();
    }

    public static Dimension2D growToFit(Dimension2D a, Bounds b) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return new Dimension2D(Math.max(a.getWidth(), b.getWidth()), Math.max(a.getHeight(), b.getHeight()));
    }

    public static boolean matches(FileChooser.ExtensionFilter filter, Path file) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        return FxUtil.matches(filter, file.toString());
    }

    public static boolean matches(FileChooser.ExtensionFilter filter, String filename) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        String fext = IoUtil.getExtension((String)filename).toLowerCase(Locale.ROOT);
        return filter.getExtensions().stream().map(ext -> PATTERN_FILENAME_AND_DOT.matcher((CharSequence)ext).replaceFirst("").toLowerCase(Locale.ROOT)).anyMatch(Predicate.isEqual(fext));
    }

    public static boolean matches(FileChooser.ExtensionFilter filter, File file) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        return FxUtil.matches(filter, file.getName());
    }

    public static boolean matches(FileChooser.ExtensionFilter filter, URI uri) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        return FxUtil.matches(filter, uri.getPath());
    }

    public static void copyToClipboard(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(s);
        clipboard.setContent((Map)content);
    }

    public static void copyToClipboard(RichText text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(text.toString());
        content.putHtml((String)HtmlConverter.create((HtmlConversionOption[])new HtmlConversionOption[]{HtmlConverter.useCss((boolean)false)}).convert(text));
        clipboard.setContent((Map)content);
    }

    public static void copyToClipboard(Image img) {
        if (img == null) {
            throw new IllegalArgumentException("img is null");
        }
        FxUtil.copyToClipboard(FxImageUtil.getInstance().convert(img));
    }

    public static void copyToClipboard(javafx.scene.image.Image img) {
        if (img == null) {
            throw new IllegalArgumentException("img is null");
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putImage(img);
        clipboard.setContent((Map)content);
    }

    public static void copyToClipboard(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        FxUtil.copyToClipboard(List.of(path));
    }

    public static void copyToClipboard(Collection<? extends Path> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths is null");
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        List<File> files = paths.stream().map(Path::toAbsolutePath).map(Path::toFile).toList();
        content.putFiles(files);
        clipboard.setContent((Map)content);
    }

    public static Optional<String> getStringFromClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString()) {
            return Optional.of(clipboard.getString());
        }
        return Optional.empty();
    }

    public static Optional<Image> getImageFromClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasImage()) {
            return Optional.of(FxImageUtil.getInstance().convert(clipboard.getImage()));
        }
        return Optional.empty();
    }

    public static Collection<Path> getFilesFromClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasFiles()) {
            return DataUtil.convert((Collection)clipboard.getFiles(), File::toPath);
        }
        return List.of();
    }

    public static EventHandler<DragEvent> dragEventHandler(Function<? super List<Path>, ? extends Collection<TransferMode>> modeGetter) {
        if (modeGetter == null) {
            throw new IllegalArgumentException("modeGetter is null");
        }
        return event -> {
            Dragboard db = event.getDragboard();
            List files = DataUtil.convert((Collection)db.getFiles(), File::toPath);
            TransferMode[] modes = (TransferMode[])((Collection)modeGetter.apply(files)).toArray(TransferMode[]::new);
            event.acceptTransferModes(modes);
            event.consume();
        };
    }

    public static EventHandler<DragEvent> dropEventHandler(Consumer<? super List<Path>> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor is null");
        }
        return event -> {
            Dragboard db = event.getDragboard();
            List paths = DataUtil.convert((Collection)db.getFiles(), File::toPath);
            processor.accept(paths);
            event.setDropCompleted(true);
            event.consume();
        };
    }

    public static Rectangle2D union(Rectangle2D r1, Rectangle2D r2) {
        if (r1 == null) {
            throw new IllegalArgumentException("r1 is null");
        }
        if (r2 == null) {
            throw new IllegalArgumentException("r2 is null");
        }
        double xMin = Math.min(r1.getMinX(), r2.getMinX());
        double yMin = Math.min(r1.getMinY(), r2.getMinY());
        double xMax = Math.max(r1.getMaxX(), r2.getMaxX());
        double yMax = Math.max(r1.getMaxY(), r2.getMaxY());
        return new Rectangle2D(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public static <T> ObservableValue<T> toObservableValue(final Value<T> value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new ObservableValue<T>(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void addListener(ChangeListener<? super T> listener) {
                if (!$assertionsDisabled && listener == null) {
                    throw new AssertionError((Object)"listener is null");
                }
                value.addChangeListener(new ChangeListenerAdapter(this, listener));
            }

            public void removeListener(ChangeListener<? super T> listener) {
                if (!$assertionsDisabled && listener == null) {
                    throw new AssertionError((Object)"listener is null");
                }
                List.copyOf(value.getChangeListeners()).stream().filter(changeListener -> {
                    if (!(changeListener instanceof ChangeListenerAdapter)) return false;
                    ChangeListenerAdapter a = (ChangeListenerAdapter)changeListener;
                    if (a.changeListener != listener) return false;
                    return true;
                }).forEach(arg_0 -> ((Value)value).removeChangeListener(arg_0));
            }

            public T getValue() {
                return value.get();
            }

            public void addListener(InvalidationListener listener) {
                if (!$assertionsDisabled && listener == null) {
                    throw new AssertionError((Object)"listener is null");
                }
                value.addChangeListener(new InvalidationListenerAdapter((Observable)this, listener));
            }

            public void removeListener(InvalidationListener listener) {
                if (!$assertionsDisabled && listener == null) {
                    throw new AssertionError((Object)"listener is null");
                }
                List.copyOf(value.getChangeListeners()).stream().filter(changeListener -> {
                    if (!(changeListener instanceof InvalidationListenerAdapter)) return false;
                    InvalidationListenerAdapter cla = (InvalidationListenerAdapter)changeListener;
                    if (cla.invalidationListener != listener) return false;
                    return true;
                }).forEach(arg_0 -> ((Value)value).removeChangeListener(arg_0));
            }

            static {
                $assertionsDisabled = !1.class.desiredAssertionStatus();
            }
        };
    }

    public static void addMouseEventHandler(Node node, EventType<MouseEvent> eventType, EventHandler<? super MouseEvent> handler) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (eventType == null) {
            throw new IllegalArgumentException("eventType is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMousePressed(), arg_0 -> ((Node)node).setOnMousePressed(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_RELEASED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseReleased(), arg_0 -> ((Node)node).setOnMouseReleased(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_CLICKED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseClicked(), arg_0 -> ((Node)node).setOnMouseClicked(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_ENTERED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseEntered(), arg_0 -> ((Node)node).setOnMouseEntered(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_EXITED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseExited(), arg_0 -> ((Node)node).setOnMouseExited(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_MOVED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseMoved(), arg_0 -> ((Node)node).setOnMouseMoved(arg_0), handler);
        } else if (eventType == MouseEvent.MOUSE_DRAGGED) {
            FxUtil.addHandler(() -> ((Node)node).getOnMouseDragged(), arg_0 -> ((Node)node).setOnMouseDragged(arg_0), handler);
        }
    }

    private static void addHandler(Supplier<? extends @Nullable EventHandler<? super MouseEvent>> getHandler, Consumer<@Nullable EventHandler<? super MouseEvent>> setHandler, EventHandler<? super MouseEvent> newHandler) {
        EventHandler<? super MouseEvent> currentHandler;
        if (!$assertionsDisabled) {
            if (getHandler == null) {
                throw new AssertionError((Object)"getHandler is null");
            }
            if (setHandler == null) {
                throw new AssertionError((Object)"setHandler is null");
            }
            if (newHandler == null) {
                throw new AssertionError((Object)"newHandler is null");
            }
        }
        if ((currentHandler = getHandler.get()) == null) {
            setHandler.accept(newHandler);
        } else {
            setHandler.accept((EventHandler<? super MouseEvent>)((EventHandler)evt -> FxUtil.handleEventChained(evt, newHandler, currentHandler)));
        }
    }

    private static <E extends Event> void handleEventChained(E evt, EventHandler<? super E> firstHandler, EventHandler<? super E> secondHandler) {
        if (!$assertionsDisabled) {
            if (evt == null) {
                throw new AssertionError((Object)"evt is null");
            }
            if (firstHandler == null) {
                throw new AssertionError((Object)"firstHandler is null");
            }
            if (secondHandler == null) {
                throw new AssertionError((Object)"secondHandler is null");
            }
        }
        firstHandler.handle(evt);
        if (!evt.isConsumed()) {
            secondHandler.handle(evt);
        }
    }

    public static <A, B> ObservableList<B> map(ObservableList<A> list, Function<A, B> mapping) {
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("mapping is null");
        }
        return new MappedList<B, A>(list, mapping);
    }

    public static Scale2f getDisplayScale(Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("screen is null");
        }
        return new Scale2f((float)screen.getOutputScaleX(), (float)screen.getOutputScaleY());
    }

    public static Scale2f getDisplayScale(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("window is null");
        }
        return FxUtil.getDisplayScale(FxUtil.getScreen(window));
    }

    public static javafx.scene.shape.Path convertToJavaFxPath(Path2f path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        javafx.scene.shape.Path jfxPath = new javafx.scene.shape.Path();
        path.segments().forEach(segment -> {
            Segment2f segment2f = segment;
            Objects.requireNonNull(segment2f);
            Segment2f selector0$temp = segment2f;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MoveTo2f.class, Line2f.class, Curve2f.class, Arc2f.class, ClosePath2f.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    MoveTo2f s = (MoveTo2f)selector0$temp;
                    jfxPath.getElements().add((Object)new MoveTo((double)s.end().x(), (double)s.end().y()));
                    break;
                }
                case 1: {
                    Line2f s = (Line2f)selector0$temp;
                    jfxPath.getElements().add((Object)new LineTo((double)s.end().x(), (double)s.end().y()));
                    break;
                }
                case 2: {
                    Curve2f s = (Curve2f)selector0$temp;
                    int n = s.numberOfControls();
                    ObservableList observableList = jfxPath.getElements();
                    observableList.add((Object)(switch (n) {
                        case 3 -> new QuadCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y());
                        case 4 -> new CubicCurveTo((double)s.control(1).x(), (double)s.control(1).y(), (double)s.control(2).x(), (double)s.control(2).y(), (double)s.control(3).x(), (double)s.control(3).y());
                        default -> throw new IllegalArgumentException("Unsupported number of control points: " + n);
                    }));
                    break;
                }
                case 3: {
                    Arc2f s = (Arc2f)selector0$temp;
                    jfxPath.getElements().add((Object)new ArcTo((double)s.rx(), (double)s.ry(), (double)s.angle(), (double)s.control(1).x(), (double)s.control(1).y(), false, false));
                    break;
                }
                case 4: {
                    ClosePath2f s = (ClosePath2f)selector0$temp;
                    jfxPath.getElements().add((Object)new ClosePath());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported segment type: " + segment.getClass().getName());
                }
            }
        });
        return jfxPath;
    }

    public static Screen getScreen(Window window) {
        double height;
        double width;
        double minY;
        if (window == null) {
            throw new IllegalArgumentException("window is null");
        }
        double minX = window.getX();
        ObservableList screens = Screen.getScreensForRectangle((double)minX, (double)(minY = window.getY()), (double)(width = window.getWidth()), (double)(height = window.getHeight()));
        return screens.isEmpty() ? Screen.getPrimary() : (Screen)screens.get(0);
    }

    public static ObservableBooleanValue constant(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Converter<Font, javafx.scene.text.Font> fontConverter() {
        return Converter.create(FX_FONT_UTIL::convert, FX_FONT_UTIL::convert);
    }

    public static Converter<Color, javafx.scene.paint.Color> colorConverter() {
        return Converter.create(FxUtil::convert, FxUtil::convert);
    }

    static class MappedList<A, B>
    extends TransformationList<A, B> {
        private final Function<B, A> converter;
        static final /* synthetic */ boolean $assertionsDisabled;

        MappedList(ObservableList<? extends B> list, Function<B, A> converter) {
            if (!$assertionsDisabled) {
                if (list == null) {
                    throw new AssertionError((Object)"list is null");
                }
                if (converter == null) {
                    throw new AssertionError((Object)"converter is null");
                }
            }
            super(list);
            this.converter = converter;
        }

        public int getSourceIndex(int index) {
            return index;
        }

        public int getViewIndex(int i) {
            return i;
        }

        protected void sourceChanged(final ListChangeListener.Change<? extends B> changeB) {
            if (!$assertionsDisabled && changeB == null) {
                throw new AssertionError((Object)"changeB is null");
            }
            ListChangeListener.Change changeA = new ListChangeListener.Change<A>((ObservableList)this){

                public boolean next() {
                    return changeB.next();
                }

                public void reset() {
                    changeB.reset();
                }

                public int getFrom() {
                    return changeB.getFrom();
                }

                public int getTo() {
                    return changeB.getTo();
                }

                public List<A> getRemoved() {
                    return DataUtil.convert((Collection)changeB.getRemoved(), converter);
                }

                protected int[] getPermutation() {
                    return new int[0];
                }
            };
            this.fireChange(changeA);
        }

        public A get(int index) {
            return this.converter.apply(this.getSource().get(index));
        }

        public int size() {
            return this.getSource().size();
        }

        static {
            $assertionsDisabled = !MappedList.class.desiredAssertionStatus();
        }
    }

    private record ChangeListenerAdapter<T>(ObservableValue<T> observableValue, ChangeListener<? super T> changeListener) implements BiConsumer<T, T>
    {
        private ChangeListenerAdapter {
            if (observableValue == null) {
                throw new NullPointerException("observableValue is null");
            }
            if (changeListener == null) {
                throw new NullPointerException("changeListener is null");
            }
        }

        @Override
        public void accept(@Nullable T t1, @Nullable T t2) {
            this.changeListener.changed(this.observableValue, t1, t2);
        }
    }

    private record InvalidationListenerAdapter<T>(Observable observable, InvalidationListener invalidationListener) implements BiConsumer<T, T>
    {
        private InvalidationListenerAdapter {
            if (observable == null) {
                throw new NullPointerException("observable is null");
            }
            if (invalidationListener == null) {
                throw new NullPointerException("invalidationListener is null");
            }
        }

        @Override
        public void accept(@Nullable T t1, @Nullable T t2) {
            this.invalidationListener.invalidated(this.observable);
        }
    }
}

