/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.logging.LogBuffer;
import com.dua3.utility.logging.LogEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.application.Platform;
import javafx.collections.ObservableListBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LogEntriesObservableList
extends ObservableListBase<LogEntry>
implements LogBuffer.LogBufferListener {
    private static final Logger LOG = LogManager.getLogger(LogEntriesObservableList.class);
    private static final long REST_TIME_IN_MS = 50L;
    private volatile List<LogEntry> data;
    private final AtomicLong totalAdded;
    private final AtomicLong totalRemoved;
    private final ReadWriteLock updateLock;
    private final Lock updateWriteLock;
    private final Condition updatesAvailableCondition;

    LogEntriesObservableList(LogBuffer buffer) {
        assert (buffer != null) : "buffer is null";
        this.data = Collections.emptyList();
        this.totalAdded = new AtomicLong(0L);
        this.totalRemoved = new AtomicLong(0L);
        this.updateLock = new ReentrantReadWriteLock();
        this.updateWriteLock = this.updateLock.writeLock();
        this.updatesAvailableCondition = this.updateWriteLock.newCondition();
        buffer.addLogBufferListener((LogBuffer.LogBufferListener)this);
        Thread updateThread = new Thread(() -> {
            while (true) {
                this.updateWriteLock.lock();
                try {
                    this.updatesAvailableCondition.await();
                    Platform.runLater(() -> {
                        try {
                            this.beginChange();
                            LogBuffer.BufferState state = buffer.getBufferState();
                            List<LogEntry> newData = Arrays.asList(state.entries());
                            this.totalAdded.getAndSet(state.totalAdded());
                            long ta = this.totalAdded.get();
                            long trOld = this.totalRemoved.getAndSet(state.totalRemoved());
                            long tr = this.totalRemoved.get();
                            assert ((long)newData.size() == ta - tr);
                            int newSz = newData.size();
                            int oldSz = this.data.size();
                            int removedRows = (int)Math.min((long)oldSz, tr - trOld);
                            int remainingRows = oldSz - removedRows;
                            int addedRows = newSz - remainingRows;
                            List<LogEntry> removed = List.copyOf(this.data.subList(0, removedRows));
                            this.data = newData;
                            this.nextRemove(0, removed);
                            this.nextAdd(newSz - addedRows, newSz);
                        }
                        finally {
                            this.endChange();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.debug("interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOG.warn("unexpected exception in update thread: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    this.updateWriteLock.unlock();
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }, "LogEntriesObservableList Update Thread");
        updateThread.setPriority(4);
        updateThread.setDaemon(true);
        updateThread.start();
    }

    public int size() {
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        return this.data.size();
    }

    public LogEntry get(int idx) {
        assert (Platform.isFxApplicationThread()) : "not on FX Application Thread";
        return this.data.get(idx);
    }

    public void entries(int removed, int added) {
        this.updateWriteLock.lock();
        try {
            this.updatesAvailableCondition.signalAll();
        }
        finally {
            this.updateWriteLock.unlock();
        }
    }

    public void clear() {
        this.updateWriteLock.lock();
        try {
            this.updatesAvailableCondition.signalAll();
        }
        finally {
            this.updateWriteLock.unlock();
        }
    }
}

