/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PlatformHelper {
    private static final Logger LOG = LogManager.getLogger(PlatformHelper.class);

    private PlatformHelper() {
    }

    public static void runAndWait(Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        PlatformHelper.runAndWait(() -> {
            try {
                action.run();
            }
            catch (Exception e) {
                LOG.warn("unexpected exception in runAndWait: {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        });
    }

    public static <T> T runAndWait(Supplier<T> action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (Platform.isFxApplicationThread()) {
            return action.get();
        }
        AtomicReference result = new AtomicReference();
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                result.set(action.get());
            }
            catch (Exception e) {
                LOG.warn("unexpected exception in runAndWait: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                doneLatch.countDown();
            }
        });
        while (doneLatch.getCount() > 0L) {
            try {
                doneLatch.await();
            }
            catch (InterruptedException e) {
                LOG.debug("interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return (T)result.get();
    }

    public static void runLater(Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        Platform.runLater(() -> {
            try {
                action.run();
            }
            catch (Exception e) {
                LOG.warn("unexpected exception in runLater: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    public static void checkApplicationThread() {
        boolean isFxApplicationThread = Platform.isFxApplicationThread();
        if (!isFxApplicationThread) {
            LOG.error("not on FX Application Thread");
            throw new IllegalStateException("not on FX Application Thread");
        }
    }
}

